/*
 * Decompiled with CFR 0.152.
 */
package stardiv.controller;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

class BusyMonitor
extends Canvas
implements Runnable {
    static final int sleepTime = 100;
    static final Color green = Color.green;
    static final Color yellow = Color.yellow;
    static final Color red = Color.red;
    static final Color darkGray = Color.darkGray;
    Font labelfont = new Font("Courier", 0, 10);
    public static int prioMin = 1;
    public static int prioMax = 10;
    MonitorThread[] threads;
    Image offscreen;
    int gap = 4;
    int border = 2;
    int barLen = 64;
    int barWid = 9;

    public BusyMonitor() {
        this.setFont(this.labelfont);
        this.setSize(this.getPreferredSize());
        this.threads = new MonitorThread[prioMax - prioMin + 1];
        int n = prioMin;
        int n2 = 0;
        while (n <= prioMax) {
            this.threads[n2] = new MonitorThread(n);
            this.threads[n2].start();
            ++n;
            ++n2;
        }
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public void suspend() {
        int n = this.threads.length;
        while (n-- != 0) {
            this.threads[n].suspend();
        }
    }

    public void resume() {
        int n = this.threads.length;
        while (n-- != 0) {
            this.threads[n].resume();
        }
    }

    public void run() {
        while (true) {
            this.updateThreadMonitors();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateThreadMonitors() {
        block11: {
            if (this.offscreen == null) {
                Dimension dimension = this.getPreferredSize();
                this.offscreen = this.createImage(dimension.width, dimension.height);
                if (this.offscreen == null) {
                    return;
                }
            }
            int n = this.border + this.gap;
            int n2 = this.border + this.gap;
            Graphics graphics = this.offscreen.getGraphics();
            if (graphics != null) {
                try {
                    Object object;
                    Dimension dimension = this.getSize();
                    graphics.setColor(this.getBackground());
                    graphics.clearRect(0, 0, dimension.width, dimension.height);
                    for (int i = 0; i < this.threads.length; ++i) {
                        object = this.threads[i];
                        int n3 = ((MonitorThread)object).slack();
                        if (n3 > 1000) {
                            n3 = 1000;
                        }
                        int n4 = this.barLen * (1000 - n3) / 1000;
                        Color color = n3 <= 333 ? green : (n3 <= 667 ? yellow : red);
                        graphics.setColor(darkGray);
                        graphics.fillRect(n, n2, this.barLen, this.barWid);
                        graphics.setColor(color);
                        graphics.fillRect(n, n2, n4, this.barWid);
                        n2 += this.barWid + this.gap;
                    }
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    graphics.setColor(this.getForeground());
                    graphics.drawString("Responsibility", n, n2 + this.getFontMetrics(this.getFont()).getMaxAscent());
                    object = this.getGraphics();
                    if (object == null) break block11;
                    try {
                        ((Graphics)object).drawImage(this.offscreen, 0, 0, null);
                    }
                    finally {
                        ((Graphics)object).dispose();
                    }
                }
                finally {
                    graphics.dispose();
                }
            }
        }
    }

    int threadCount() {
        return prioMax - prioMin + 1;
    }

    public Dimension getPreferredSize() {
        int n = this.threadCount();
        int n2 = this.barLen + 2 * this.border + 2 * this.gap;
        int n3 = this.barWid * n + 2 * this.border + (n + 1) * this.gap;
        if (this.getFont() != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            n2 = Math.max(n2, fontMetrics.stringWidth("Responsibility") + 2 * this.border + 2 * this.gap);
            n3 += fontMetrics.getHeight();
        }
        return new Dimension(n2, n3);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.clearRect(0, 0, dimension.width, dimension.height);
    }

    class MonitorThread
    extends Thread {
        final int sleepTime = 10;
        long lastUpdated = -1L;
        int priority = 5;

        MonitorThread(int n) {
            this.priority = n;
            this.setDaemon(true);
            this.setPriority(n);
            this.setName("PerfCheck " + n);
        }

        int slack() {
            return (int)(System.currentTimeMillis() - this.lastUpdated);
        }

        public void run() {
            while (true) {
                this.lastUpdated = System.currentTimeMillis();
                try {
                    MonitorThread.sleep(10L);
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

