/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.db;

import java.io.IOException;
import java.io.RandomAccessFile;

class Block {
    public static final int HEADERLEN = 8;
    public static final int IDLEN = 4;
    public int _number;
    public boolean _isLeaf = true;
    public int _free = 0;
    public final byte[] _data;

    public Block(int n) {
        this._data = new byte[n - 8];
    }

    public final void setBlockNumber(int n) {
        this._number = n;
    }

    public void setFree(int n) {
        this._free = n;
    }

    public final int integerAt(int n) {
        return (((this._data[n++] & 0xFF) << 8 | this._data[n++] & 0xFF) << 8 | this._data[n++] & 0xFF) << 8 | this._data[n] & 0xFF;
    }

    public final void setIntegerAt(int n, int n2) {
        this._data[n++] = (byte)(n2 >>> 24 & 0xFF);
        this._data[n++] = (byte)(n2 >>> 16 & 0xFF);
        this._data[n++] = (byte)(n2 >>> 8 & 0xFF);
        this._data[n] = (byte)(n2 & 0xFF);
    }

    public static final Block readIn(RandomAccessFile randomAccessFile, Block block) throws IOException {
        block._number = randomAccessFile.readInt();
        int n = randomAccessFile.readInt();
        block._isLeaf = (n & Integer.MIN_VALUE) != 0;
        block._free = n & Integer.MAX_VALUE;
        randomAccessFile.readFully(block._data);
        return block;
    }

    public final void writeOut(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(this._number);
        randomAccessFile.writeInt(this._free | (this._isLeaf ? Integer.MIN_VALUE : 0));
        randomAccessFile.write(this._data);
    }
}

