/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.util;

import com.sun.xmlsearch.util.LineInput;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class IndexAccessor {
    private final String _dirName;

    public IndexAccessor(String string) {
        this._dirName = string;
    }

    public IndexAccessor(IndexAccessor indexAccessor) {
        this._dirName = indexAccessor._dirName;
    }

    public void createIfNeeded() throws Exception {
        File file = this.indexFile(".");
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void clear() throws IOException {
        File file = this.indexFile(".");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
    }

    public File indexFile(String string) {
        return new File(this._dirName, string);
    }

    public RandomAccessFile getRAF(String string, boolean bl) throws IOException {
        return new RandomAccessFile(this.indexFile(string), bl ? "rw" : "r");
    }

    public InputStream getInputStream(String string) throws IOException {
        return new BufferedInputStream(new FileInputStream(this.indexFile(string)));
    }

    public OutputStream getOutputStream(String string) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(this.indexFile(string)));
    }

    public FileWriter makeFileWriter(String string) throws IOException {
        return new FileWriter(this.indexFile(string));
    }

    public byte[] readByteArray(String string) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        InputStream inputStream = this.getInputStream(string);
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public LineInput getLineInput(String string) throws FileNotFoundException {
        return new LineInput(this.indexFile(string));
    }

    public void outputObject(String string, Object object) throws IOException {
        OutputStream outputStream = this.getOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        outputStream.close();
    }

    public Object readObject(String string) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(this.getInputStream(string));
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }
}

