/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.util;

import java.io.PrintStream;
import java.util.Arrays;

public final class IntegerArray {
    private static final int InitialSize = 128;
    private int[] _array;
    private int _size;
    private int _free = 0;

    public IntegerArray() {
        this(128);
    }

    public IntegerArray(int n) {
        this._size = n;
        this._array = new int[this._size];
    }

    public IntegerArray(int[] nArray) {
        this(nArray.length);
        this._free = this._size;
        System.arraycopy(nArray, 0, this._array, 0, this._free);
    }

    public void clear() {
        this._free = 0;
    }

    public int[] toIntArray() {
        int[] nArray = new int[this.cardinality()];
        System.arraycopy(this._array, 0, nArray, 0, this.cardinality());
        return nArray;
    }

    public final int at(int n) {
        return this._array[n];
    }

    public final void set(int n, int n2) {
        this._array[n] = n2;
    }

    public int indexOf(int n) {
        for (int i = 0; i < this._free; ++i) {
            if (n != this._array[i]) continue;
            return i;
        }
        return -1;
    }

    public final void add(int n) {
        if (this._free == this._size) {
            this.growArray(this._size * 2);
        }
        this._array[this._free++] = n;
    }

    public void addNew(int n) {
        for (int i = 0; i < this._free; ++i) {
            if (this._array[i] != n) continue;
            return;
        }
        this.add(n);
    }

    private void growArray(int n) {
        this._size = n;
        int[] nArray = new int[this._size];
        System.arraycopy(this._array, 0, nArray, 0, this._free);
        this._array = nArray;
    }

    public int popLast() {
        return this._array[--this._free];
    }

    public int last() {
        return this._array[this._free - 1];
    }

    public void pop() {
        --this._free;
    }

    public void pop(int n) {
        this._free -= n;
    }

    public final int cardinality() {
        return this._free;
    }

    public void sort() {
        Arrays.sort(this._array, 0, this._free);
    }

    public void toDifferences(IntegerArray integerArray) {
        if (integerArray._size < this._size) {
            integerArray.growArray(this._size);
        }
        if ((integerArray._free = this._free) > 0) {
            integerArray._array[0] = this._array[0];
            for (int i = 1; i < this._free; ++i) {
                integerArray._array[i] = this._array[i] - this._array[i - 1];
            }
        }
    }

    public int binarySearch(int n) {
        int n2 = 0;
        int n3 = this._free;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            if (this._array[n4] < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n < this._array[n4]) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -1;
    }

    public void print(PrintStream printStream) {
        if (this._free > 0) {
            for (int i = 0; i < this._free - 1; ++i) {
                printStream.print(this._array[i]);
                printStream.print(' ');
            }
            printStream.println(this._array[this._free - 1]);
        } else {
            printStream.println("IntegerArray: empty");
        }
    }
}

