/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.util.ByteArrayDecompressor;
import com.sun.xmlsearch.util.IntegerArray;
import com.sun.xmlsearch.xml.XmlIndex;
import com.sun.xmlsearch.xml.qe.ConceptData;
import com.sun.xmlsearch.xml.qe.ConceptGroupGenerator;
import com.sun.xmlsearch.xml.qe.GeneratorHeap;
import com.sun.xmlsearch.xml.qe.NextDocGenerator;
import com.sun.xmlsearch.xml.qe.NextDocGeneratorHeap;
import com.sun.xmlsearch.xml.qe.Query;
import com.sun.xmlsearch.xml.qe.QueryFactoryImpl;
import com.sun.xmlsearch.xml.qe.RoleFiller;

final class Search {
    private static final int InitNConcepts = 128;
    private XmlIndex _env;
    private int _max;
    private int _nConcepts;
    private int _nQueries;
    private int _nQueriesSize = 8;
    private ConceptGroupGenerator _firstGenerator = new ConceptGroupGenerator();
    private int[] _concepts = new int[16];
    private int _free2;
    private int _size2;
    private int _startingIndex = 0;
    private int _limit = 0;
    private Query[] _queries;
    private ConceptData[] _conceptData;
    private GeneratorHeap _genHeap = new GeneratorHeap();
    private int _document;
    private byte[] _data = null;
    private int _base = 0;
    private NextDocGeneratorHeap _nextDocGenHeap = new NextDocGeneratorHeap();
    private IntegerArray _kTable = new IntegerArray();
    private IntegerArray _offsets = new IntegerArray();
    private IntegerArray _maxConcepts = new IntegerArray();
    private IntegerArray _docConcepts = new IntegerArray();
    private IntegerArray _queryMasks = new IntegerArray();
    private int _maxHitsToShow = 25;
    private QueryFactoryImpl _queryFactory = new QueryFactoryImpl();

    public Search(XmlIndex xmlIndex) {
        this._env = xmlIndex;
        this._nQueries = 0;
        this._queries = new Query[this._nQueriesSize];
        this._size2 = 128;
        this._free2 = 0;
        this._conceptData = new ConceptData[this._size2];
    }

    private void addTerm(int n, int n2, double d, int n3) {
        if (this._env.occursInText(n2)) {
            this.addConceptData(this._queries[n3].makeConceptData(n3, n, n2, d));
        }
    }

    public void addConceptData(ConceptData conceptData) {
        if (this._free2 == this._size2) {
            ConceptData[] conceptDataArray = new ConceptData[this._size2 *= 2];
            System.arraycopy(this._conceptData, 0, conceptDataArray, 0, this._free2);
            this._conceptData = conceptDataArray;
        }
        this._conceptData[this._free2++] = conceptData;
    }

    public Query addQuery(String string, int n, int n2, int n3, int[] nArray, IntegerArray[] integerArrayArray, double d) {
        Query query = this._queryFactory.makeQuery(this._env, string, n, n3);
        query.missingTerms(n2);
        int n4 = this._nQueries++;
        if (n4 == this._nQueriesSize) {
            Query[] queryArray = new Query[this._nQueriesSize *= 2];
            System.arraycopy(this._queries, 0, queryArray, 0, n4);
            this._queries = queryArray;
        }
        this._queries[n4] = query;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] > 0) {
                this.addTerm(i, nArray[i], 0.0, n4);
            }
            for (int j = 0; j < integerArrayArray[i].cardinality(); ++j) {
                this.addTerm(i, integerArrayArray[i].at(j), d, n4);
            }
        }
        query.addControlConceptData(this, n4);
        return query;
    }

    public void startSearch() {
        int n;
        this.quicksort(0, this._free2 - 1);
        int n2 = 0;
        while (n2 < this._free2 - 1) {
            for (n = n2 + 1; n < this._free2; ++n) {
                if (this._conceptData[n2].crqEquals(this._conceptData[n])) {
                    this._conceptData[n] = null;
                    continue;
                }
                n2 = n;
            }
            n2 = n;
        }
        n2 = 0;
        while (n2 < this._free2 - 1) {
            for (n = n2 + 1; n < this._free2; ++n) {
                if (this._conceptData[n] == null) continue;
                if (this._conceptData[n2].cEquals(this._conceptData[n])) {
                    this._conceptData[n2].addLast(this._conceptData[n]);
                    this._conceptData[n] = null;
                    continue;
                }
                n2 = n;
            }
            n2 = n;
        }
        block6: for (n2 = 0; n2 < this._free2 - 1; ++n2) {
            if (this._conceptData[n2] != null) continue;
            for (n = n2 + 1; n < this._free2; ++n) {
                if (this._conceptData[n] == null) continue;
                this._conceptData[n2] = this._conceptData[n];
                this._conceptData[n] = null;
                continue block6;
            }
        }
        this._nextDocGenHeap.reset();
        for (n2 = 0; n2 < this._free2 && this._conceptData[n2] != null; ++n2) {
            NextDocGenerator nextDocGenerator = new NextDocGenerator(this._conceptData[n2], this._env);
            try {
                nextDocGenerator.first();
                if (nextDocGenerator.getDocument() == -1) continue;
                this._nextDocGenHeap.addGenerator(nextDocGenerator);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this._nextDocGenHeap.start();
        this._env.reset();
        this._env.resetContextSearch();
        this.searchDocument();
    }

    private void searchDocument() {
        RoleFiller[] roleFillerArray = new RoleFiller[this._nQueries];
        do {
            try {
                switch (this.nextDocument(roleFillerArray)) {
                    case 0: {
                        this._genHeap.start(roleFillerArray);
                        while (this._genHeap.next(roleFillerArray)) {
                        }
                        break;
                    }
                    case 1: {
                        if (!this._firstGenerator.next()) break;
                        this._firstGenerator.generateFillers(roleFillerArray);
                        while (this._firstGenerator.next()) {
                            this._firstGenerator.generateFillers(roleFillerArray);
                        }
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                continue;
            }
            for (int i = 0; i < this._nQueries; ++i) {
                RoleFiller roleFiller;
                RoleFiller roleFiller2 = roleFillerArray[i];
                if (roleFiller2 != null && roleFiller2 != RoleFiller.STOP) {
                    roleFiller2.scoreList(this._queries[i], this._document);
                    continue;
                }
                if (!this._queries[i].zoned() || (roleFiller = this._queries[i].getRoleFillers()) == null || roleFiller == RoleFiller.STOP) continue;
                roleFiller.scoreList(this._queries[i], this._document);
            }
            this._genHeap.reset();
        } while (this._nextDocGenHeap.isNonEmpty());
    }

    private int indexOf(int n) throws Exception {
        int n2 = this._startingIndex;
        int n3 = this._nConcepts;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            if (this._concepts[n4] < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n < this._concepts[n4]) {
                n3 = n4 - 1;
                continue;
            }
            this._startingIndex = n4 + 1;
            return n4;
        }
        throw new Exception("indexOf " + n + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void results() {
        for (int i = 0; i < this._nQueries; ++i) {
            System.out.println("query " + i);
            if (this._queries[i] == null) continue;
            Query query = this._queries[i];
            synchronized (query) {
                this._queries[i].notify();
                continue;
            }
        }
    }

    private ConceptGroupGenerator makeGenerator(int n) throws Exception {
        int n2;
        int n3;
        if (n > 0) {
            n3 = this._base + this._offsets.at(n - 1);
            n2 = this._maxConcepts.at(n - 1);
        } else {
            n3 = this._base;
            n2 = 0;
        }
        ConceptGroupGenerator conceptGroupGenerator = new ConceptGroupGenerator(this._data, n3, this._kTable.at(2 * n + 1));
        this._nConcepts = conceptGroupGenerator.decodeConcepts(this._kTable.at(2 * n), n2, this._concepts);
        this._max = n < this._limit ? (this._concepts[this._nConcepts] = this._maxConcepts.at(n)) : this._concepts[this._nConcepts - 1];
        this._genHeap.addGenerator(conceptGroupGenerator);
        this._startingIndex = 0;
        return conceptGroupGenerator;
    }

    private boolean openDocumentIndex(int n) throws Exception {
        this._data = this._env.getPositions(n);
        this._base = this._env.getDocumentIndex(n);
        this._startingIndex = 0;
        int n2 = this._data[this._base] & 0xFF;
        switch (n2 >> 6) {
            case 0: {
                byte by = this._data[this._base + 1];
                this._firstGenerator.init(this._data, this._base += 2, by);
                this._nConcepts = this._firstGenerator.decodeConcepts(n2 & 0x3F, 0, this._concepts);
                return false;
            }
            case 2: {
                this._kTable.clear();
                this._offsets.clear();
                this._maxConcepts.clear();
                ByteArrayDecompressor byteArrayDecompressor = new ByteArrayDecompressor(this._data, this._base + 1);
                byteArrayDecompressor.decode(n2 & 0x3F, this._kTable);
                byteArrayDecompressor.ascDecode(this._kTable.popLast(), this._offsets);
                byteArrayDecompressor.ascDecode(this._kTable.popLast(), this._maxConcepts);
                this._base += 1 + byteArrayDecompressor.bytesRead();
                this._limit = this._maxConcepts.cardinality();
                return true;
            }
            case 1: 
            case 3: {
                throw new Exception("extents not yet implemented\n");
            }
        }
        return false;
    }

    private int nextDocument(RoleFiller[] roleFillerArray) throws Exception {
        while (this._nextDocGenHeap.isNonEmpty()) {
            int n;
            for (n = 0; n < this._nQueries; ++n) {
                if (this._queries[n] == null) continue;
                this._queries[n].resetForNextDocument();
            }
            n = 0;
            this._document = this._nextDocGenHeap.getDocument();
            this._docConcepts.clear();
            this._queryMasks.clear();
            do {
                this._docConcepts.add(this._nextDocGenHeap.getConcept());
                this._queryMasks.add(this._nextDocGenHeap.getQueryMask());
                int n2 = n++;
                ConceptData conceptData = this._nextDocGenHeap.getTerms();
                this._conceptData[n2] = conceptData;
                conceptData.runBy(this._queries);
                this._nextDocGenHeap.step();
            } while (this._nextDocGenHeap.atDocument(this._document));
            int n3 = 0;
            for (int i = 0; i < this._nQueries; ++i) {
                Query query = this._queries[i];
                if (query == null) continue;
                query.saveRoleFillers(null);
                if (query.vote()) {
                    roleFillerArray[i] = query.zoned() ? RoleFiller.STOP : null;
                    n3 |= 1 << i;
                    continue;
                }
                roleFillerArray[i] = RoleFiller.STOP;
            }
            if (n3 == 0) continue;
            if (this.openDocumentIndex(this._document)) {
                int n4 = 0;
                while ((this._queryMasks.at(n4) & n3) == 0) {
                    ++n4;
                }
                int n5 = this._docConcepts.at(n4);
                int n6 = 0;
                while (n5 > this._maxConcepts.at(n6) && ++n6 < this._limit) {
                }
                ConceptGroupGenerator conceptGroupGenerator = this.makeGenerator(n6);
                conceptGroupGenerator.addTerms(this.indexOf(n5), this._conceptData[n4]);
                ++n4;
                while (n4 < n) {
                    if ((this._queryMasks.at(n4) & n3) > 0) {
                        n5 = this._docConcepts.at(n4);
                        if (n5 > this._max) {
                            while (n5 > this._maxConcepts.at(n6) && ++n6 < this._limit) {
                            }
                            conceptGroupGenerator = this.makeGenerator(n6);
                        }
                        conceptGroupGenerator.addTerms(this.indexOf(n5), this._conceptData[n4]);
                    }
                    ++n4;
                }
                return 0;
            }
            for (int i = 0; i < n; ++i) {
                if ((this._queryMasks.at(i) & n3) == 0) continue;
                this._firstGenerator.addTerms(this.indexOf(this._docConcepts.at(i)), this._conceptData[i]);
            }
            return 1;
        }
        return 2;
    }

    public void listPositions() throws Exception {
        for (int i = 0; i < this._env.nDocuments(); ++i) {
            int n;
            if (this.openDocumentIndex(i)) {
                System.out.println("open document " + this._env.documentName(i));
                for (n = 0; n <= this._limit; ++n) {
                    ConceptGroupGenerator conceptGroupGenerator = this.makeGenerator(n);
                    System.out.println("generator " + n);
                    while (conceptGroupGenerator.step()) {
                        int n2 = conceptGroupGenerator.getConceptCode();
                        int n3 = this._concepts[n2];
                        String string = this._env.fetch(n3);
                        System.out.println("\t" + string + " @ " + conceptGroupGenerator.position());
                    }
                }
                continue;
            }
            System.out.println("open document " + this._env.documentName(i));
            System.out.println("only generator");
            while (this._firstGenerator.step()) {
                n = this._firstGenerator.getConceptCode();
                int n4 = this._concepts[n];
                String string = this._env.fetch(n4);
                System.out.println("\t" + string + " @ " + this._firstGenerator.position());
            }
        }
    }

    public void listConcepts(int n, int n2, int n3) throws Exception {
        if (this.openDocumentIndex(n)) {
            Object object;
            int n4;
            System.out.println("open document " + this._env.documentName(n));
            GeneratorHeap generatorHeap = new GeneratorHeap();
            for (n4 = 0; n4 <= this._limit; ++n4) {
                ConceptGroupGenerator conceptGroupGenerator = this.makeGenerator(n4);
                generatorHeap.addGenerator(conceptGroupGenerator);
                object = new int[16];
                System.arraycopy(this._concepts, 0, object, 0, ((int[])object).length);
                conceptGroupGenerator.setConceptTable((int[])object);
            }
            if (generatorHeap.start()) {
                do {
                    n4 = generatorHeap.position();
                    int n5 = generatorHeap.getConcept();
                    if (n4 <= n2 || n4 >= n3) continue;
                    object = this._env.fetch(n5);
                    System.out.println("\t" + (String)object + " @ " + n4);
                } while (generatorHeap.next());
            }
        } else {
            System.out.println("open document " + this._env.documentName(n));
            System.out.println("only generator");
            while (this._firstGenerator.step()) {
                int n6 = this._firstGenerator.getConceptCode();
                int n7 = this._concepts[n6];
                String string = this._env.fetch(n7);
                System.out.println("\t" + string + " @ " + this._firstGenerator.position());
            }
        }
    }

    private int partition(int n, int n2) {
        ConceptData conceptData = this._conceptData[n + n2 >>> 1];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (conceptData.compareWith(this._conceptData[--n4])) {
                continue;
            }
            while (this._conceptData[++n3].compareWith(conceptData)) {
            }
            if (n3 >= n4) break;
            ConceptData conceptData2 = this._conceptData[n3];
            this._conceptData[n3] = this._conceptData[n4];
            this._conceptData[n4] = conceptData2;
        }
        return n4;
    }

    private void quicksort(int n, int n2) {
        while (n < n2) {
            int n3 = this.partition(n, n2);
            this.quicksort(n, n3);
            n = n3 + 1;
        }
    }
}

