/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public final class Debug {
    public static final int INFO = 1;
    public static final int ERROR = 2;
    public static final int TRACE = 4;
    public static final boolean SET = true;
    public static final boolean UNSET = false;
    private static int flags = 0;
    private static PrintWriter writer = null;

    static {
        try {
            Class<?> clazz = new Debug().getClass();
            InputStream inputStream = clazz.getResourceAsStream("Debug.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty("debug.info", "false");
            string = string.toLowerCase();
            if (string.equals("true")) {
                Debug.setFlags(1, true);
            }
            String string2 = properties.getProperty("debug.trace", "false");
            if ((string2 = string2.toLowerCase()).equals("true")) {
                Debug.setFlags(4, true);
            }
            String string3 = properties.getProperty("debug.error", "false");
            if ((string3 = string3.toLowerCase()).equals("true")) {
                Debug.setFlags(2, true);
            }
            String string4 = properties.getProperty("debug.output", "System.out");
            Debug.setOutput(string4);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    private Debug() {
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            String string = Integer.toHexString(n2);
            if (string.length() < 2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isFlagSet(int n) {
        return (flags & n) != 0;
    }

    public static void log(int n, String string) {
        if (Debug.isFlagSet(n) && writer != null) {
            writer.println(string);
        }
    }

    public static void log(int n, String string, Throwable throwable) {
        if (Debug.isFlagSet(n) && writer != null) {
            writer.println(string);
            if (throwable != null) {
                throwable.printStackTrace(writer);
            }
        }
    }

    public static void logSystemInfo() {
        if (writer != null) {
            writer.println();
            writer.println("Platform Information:");
            writer.println("OS          : " + System.getProperty("os.name"));
            writer.println("Version     : " + System.getProperty("os.version"));
            writer.println("Platform    : " + System.getProperty("os.arch"));
            writer.println("JDK Version : " + System.getProperty("java.version"));
            writer.println("JDK Vendor  : " + System.getProperty("java.vendor"));
            writer.println();
        }
    }

    public static void logTime() {
        if (writer != null) {
            Date date = Calendar.getInstance().getTime();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
            writer.println(dateFormat.format(date));
        }
    }

    private static void setFlags(int n, boolean bl) {
        flags = bl ? (flags |= n) : (flags &= ~n);
    }

    private static void setOutput(OutputStream outputStream) {
        Debug.setOutput(new OutputStreamWriter(outputStream));
    }

    private static void setOutput(Writer writer) {
        if (Debug.writer != null) {
            Debug.writer.close();
        }
        Debug.writer = new PrintWriter((Writer)new BufferedWriter(writer), true);
    }

    private static void setOutput(String string) {
        block6: {
            if (writer != null) break block6;
            if (string.equals("System.out")) {
                Debug.setOutput(System.out);
            } else if (string.equals("System.err")) {
                Debug.setOutput(System.err);
            } else {
                try {
                    Debug.setOutput(new FileWriter(string));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
    }
}

