/*************************************************************************
 *
 *  $RCSfile: CompoundTypeDescription.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.comp.typedescriptionmanager;

import com.sun.star.uno.*;
import com.sun.star.uno.RuntimeException;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.reflection.XTypeDescription;
import com.sun.star.reflection.XCompoundTypeDescription;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;


//==================================================================================================
class CompoundTypeDescription extends TypeDescription implements XCompoundTypeDescription
{
	private TypeDescriptionManager	_tdmanager;
	private boolean					_bBaseTypeSet = false;
	private XTypeDescription		_xBaseType;
	private XTypeDescription[]		_memberTypes = null;
	private String[]				_memberNames = null;
	
	//______________________________________________________________________________________________
	public CompoundTypeDescription( TypeDescriptionManager tdmanager, Class c, TypeClass typeClass )
	{
		super( c, typeClass );
		this._tdmanager = tdmanager;
	}
	
	// XCompoundTypeDescription
	//______________________________________________________________________________________________
	public XTypeDescription getBaseType()
		throws RuntimeException
	{
		if (! _bBaseTypeSet)
		{
			try
			{
				Class c = _class.getSuperclass();
				_xBaseType = (XTypeDescription)(c != null ? _tdmanager.getByClass( c, false, false ) : null);
			}
			catch (NoSuchElementException exc)
			{
			}
			catch (ClassCastException exc)
			{
			}
			_bBaseTypeSet = true;
		}
		return _xBaseType;
	}
	
	//______________________________________________________________________________________________
	private void init()
		throws RuntimeException
	{
		Field[] fields = _class.getDeclaredFields();
		if (fields != null)
		{
			int nFields = fields.length;
			XTypeDescription[] memberTypes = new XTypeDescription[nFields];
			String[] memberNames		   = new String[nFields];
			
			int nLen = 0;
			for ( int nPos = 0; nPos < nFields; ++nPos )
			{
				Field field = fields[nPos];
				int nMod = field.getModifiers();
				if (Modifier.isPublic( nMod ) && !Modifier.isStatic( nMod ))
				{
					try
					{
						memberTypes[nPos] = (XTypeDescription)_tdmanager.getByClass(
							field.getType(), isUnsigned( field.getName() ), isInterface( field.getName() ) );
						memberNames[nPos] = field.getName();
						++nLen;
					}
					catch (NoSuchElementException exc)
					{
					}
				}
			}
			
			if (nLen != nFields)
			{
				XTypeDescription[] membTypes = new XTypeDescription[nLen];
				String[] membNames			 = new String[nLen];
				System.arraycopy( memberTypes, 0, membTypes, 0, nLen );
				System.arraycopy( memberNames, 0, membNames, 0, nLen );
				_memberTypes = membTypes;
				_memberNames = membNames;
			}
			else
			{
				_memberTypes = memberTypes;
				_memberNames = memberNames;
			}
		}
	}
	//______________________________________________________________________________________________
    public XTypeDescription[] getMemberTypes()
		throws RuntimeException
	{
		if (_memberTypes == null)
			init();
		return _memberTypes;
	}
	//______________________________________________________________________________________________
    public String[] getMemberNames() throws
		RuntimeException
	{
		if (_memberNames == null)
			init();
		return _memberNames;
	}
}

