/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.xml.EmbeddedBinaryObject;
import org.openoffice.xmerge.converter.xml.EmbeddedObject;
import org.openoffice.xmerge.converter.xml.EmbeddedXMLObject;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.OfficeDocumentException;
import org.openoffice.xmerge.converter.xml.OfficeZip;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.Resources;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class OfficeDocument
implements Document,
OfficeConstants {
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private org.w3c.dom.Document contentDoc = null;
    private org.w3c.dom.Document metaDoc = null;
    private org.w3c.dom.Document settingsDoc = null;
    private org.w3c.dom.Document styleDoc = null;
    private org.w3c.dom.Document manifestDoc = null;
    private String documentName = null;
    private String fileName = null;
    private Resources res = Resources.getInstance();
    private OfficeZip zip = null;
    private Map embeddedObjects = null;

    public OfficeDocument(String string) {
        this(string, true, false);
    }

    public OfficeDocument(String string, boolean bl, boolean bl2) {
        factory.setValidating(bl2);
        factory.setNamespaceAware(bl);
        this.documentName = this.trimDocumentName(string);
        this.fileName = String.valueOf(this.documentName) + this.getFileExtension();
    }

    public void addEmbeddedObject(EmbeddedObject embeddedObject) {
        if (embeddedObject == null) {
            return;
        }
        if (this.embeddedObjects == null) {
            this.embeddedObjects = new HashMap();
        }
        this.embeddedObjects.put(embeddedObject.getName(), embeddedObject);
    }

    private final org.w3c.dom.Document createDOM(String string) throws IOException {
        Object object;
        org.w3c.dom.Document document = null;
        try {
            object = factory.newDocumentBuilder();
            document = ((DocumentBuilder)object).newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OfficeDocumentException(parserConfigurationException);
        }
        object = document.createElement(string);
        document.appendChild((Node)object);
        object.setAttribute("xmlns:office", "http://openoffice.org/2000/office");
        object.setAttribute("xmlns:style", "http://openoffice.org/2000/style");
        object.setAttribute("xmlns:text", "http://openoffice.org/2000/text");
        object.setAttribute("xmlns:table", "http://openoffice.org/2000/table");
        object.setAttribute("xmlns:draw", "http://openoffice.org/2000/drawing");
        object.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
        object.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        object.setAttribute("xmlns:number", "http://openoffice.org/2000/datastyle");
        object.setAttribute("xmlns:svg", "http://www.w3.org/2000/svg");
        object.setAttribute("xmlns:chart", "http://openoffice.org/2000/chart");
        object.setAttribute("xmlns:dr3d", "http://openoffice.org/2000/dr3d");
        object.setAttribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
        object.setAttribute("xmlns:form", "http://openoffice.org/2000/form");
        object.setAttribute("xmlns:script", "http://openoffice.org/2000/script");
        object.setAttribute("office:class", this.getOfficeClassAttribute());
        object.setAttribute("office:version", "1.0");
        return document;
    }

    private final org.w3c.dom.Document createSettingsDOM(String string) throws IOException {
        Object object;
        org.w3c.dom.Document document = null;
        try {
            object = factory.newDocumentBuilder();
            document = ((DocumentBuilder)object).newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OfficeDocumentException(parserConfigurationException);
        }
        object = document.createElement(string);
        document.appendChild((Node)object);
        object.setAttribute("xmlns:office", "http://openoffice.org/2000/office");
        object.setAttribute("xmlns:xlink", "http://openoffice.org/1999/xlink");
        object.setAttribute("xmlns:config", "http://openoffice.org/2001/config");
        object.setAttribute("office:version", "1.0");
        return document;
    }

    static byte[] docToBytes(org.w3c.dom.Document document) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream;
        block6: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            String string = document.getClass().getName();
            try {
                if (string.equals("com.sun.xml.tree.XmlDocument")) {
                    Debug.log(1, "Using JAXP");
                    object = Class.forName("com.sun.xml.tree.XmlDocument");
                    Method method = ((Class)object).getMethod("write", Class.forName("java.io.OutputStream"));
                    method.invoke((Object)document, byteArrayOutputStream);
                    break block6;
                }
                if (string.equals("org.apache.crimson.tree.XmlDocument")) {
                    Debug.log(1, "Using Crimson");
                    object = Class.forName("org.apache.crimson.tree.XmlDocument");
                    Method method = ((Class)object).getMethod("write", Class.forName("java.io.OutputStream"));
                    method.invoke((Object)document, byteArrayOutputStream);
                    break block6;
                }
                if (string.equals("org.apache.xerces.dom.DocumentImpl") || string.equals("org.apache.xerces.dom.DeferredDocumentImpl")) {
                    Debug.log(1, "Using Xerces");
                    object = Class.forName("org.apache.xml.serialize.XMLSerializer");
                    Constructor<?> constructor = ((Class)object).getConstructor(Class.forName("java.io.OutputStream"), Class.forName("org.apache.xml.serialize.OutputFormat"));
                    Method method = ((Class)object).getMethod("serialize", Class.forName("org.w3c.dom.Document"));
                    Object obj = constructor.newInstance(byteArrayOutputStream, null);
                    method.invoke(obj, document);
                    break block6;
                }
                throw new IOException("No appropriate API (JAXP/Xerces) to serialize XML document: " + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        object = byteArrayOutputStream.toByteArray();
        return object;
    }

    public org.w3c.dom.Document getContentDOM() {
        return this.contentDoc;
    }

    protected abstract String getDocumentMimeType();

    public EmbeddedObject getEmbeddedObject(String string) {
        if (string == null) {
            return null;
        }
        if (this.embeddedObjects == null) {
            this.getEmbeddedObjects();
        }
        if (this.embeddedObjects.containsKey(string)) {
            return (EmbeddedObject)this.embeddedObjects.get(string);
        }
        return null;
    }

    public Iterator getEmbeddedObjects() {
        if (this.embeddedObjects == null && this.manifestDoc != null) {
            this.embeddedObjects = new HashMap();
            NodeList nodeList = this.manifestDoc.getElementsByTagName("manifest:file-entry");
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string = namedNodeMap.getNamedItem("manifest:media-type").getNodeValue();
                String string2 = namedNodeMap.getNamedItem("manifest:full-path").getNodeValue();
                if (string.startsWith("application/vnd.sun.xml")) {
                    if (!string2.equals("/")) {
                        String string3 = string2.substring(0, string2.length() - 1);
                        this.embeddedObjects.put(string3, new EmbeddedXMLObject(string3, string, this.zip));
                    }
                } else if (!string.equals("text/xml")) {
                    this.embeddedObjects.put(string2, new EmbeddedBinaryObject(string2, string, this.zip));
                }
                ++n2;
            }
        }
        return this.embeddedObjects.values().iterator();
    }

    protected abstract String getFileExtension();

    public String getFileName() {
        return this.fileName;
    }

    public org.w3c.dom.Document getMetaDOM() {
        return this.metaDoc;
    }

    public String getName() {
        return this.documentName;
    }

    protected abstract String getOfficeClassAttribute();

    public org.w3c.dom.Document getSettingsDOM() {
        return this.settingsDoc;
    }

    public org.w3c.dom.Document getStyleDOM() {
        return this.styleDoc;
    }

    private static Reader hack(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        StringBuffer stringBuffer = new StringBuffer(inputStream.available());
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf("<!DOCTYPE");
            if (n > -1) {
                stringBuffer.append(string.substring(0, n));
                int n2 = string.indexOf(62, n + 8);
                if (n2 > -1) {
                    stringBuffer.append(string.substring(n2 + 1, string.length()));
                    stringBuffer.append("\n");
                    continue;
                }
                boolean bl = false;
                while ((string = bufferedReader.readLine()) != null) {
                    n2 = string.indexOf(62);
                    if (n2 <= -1) continue;
                    stringBuffer.append(string.substring(n2 + 1));
                    stringBuffer.append("\n");
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new IOException("Invalid XML");
            }
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        StringReader stringReader = new StringReader(stringBuffer.toString());
        return stringReader;
    }

    public final void initContentDOM() throws IOException {
        this.contentDoc = this.createDOM("office:document-content");
        Element element = this.contentDoc.getDocumentElement();
        Element element2 = this.contentDoc.createElement("office:font-decls");
        element.appendChild(element2);
        element2 = this.contentDoc.createElement("office:automatic-styles");
        element.appendChild(element2);
        element2 = this.contentDoc.createElement("office:body");
        element.appendChild(element2);
    }

    private void initManifestDOM() throws IOException {
        Object object;
        Object object2;
        try {
            object2 = factory.newDocumentBuilder();
            object = object2.getDOMImplementation();
            DocumentType documentType = object.createDocumentType("manifest:manifest", "-//OpenOffice.org//DTD Manifest 1.0//EN", "Manifest.dtd");
            this.manifestDoc = object.createDocument("manifest", "manifest:manifest", documentType);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OfficeDocumentException(parserConfigurationException);
        }
        object2 = this.manifestDoc.getDocumentElement();
        object2.setAttribute("xmlns:manifest", "http://openoffice.org/2001/manifest");
        object = this.manifestDoc.createElement("manifest:file-entry");
        object.setAttribute("manifest:full-path", "/");
        object.setAttribute("manifest:media-type", this.getDocumentMimeType());
        object2.appendChild((Node)object);
    }

    public final void initSettingsDOM() throws IOException {
        this.settingsDoc = this.createSettingsDOM("office:document-settings");
        Element element = this.settingsDoc.getDocumentElement();
        Element element2 = this.settingsDoc.createElement("office:settings");
        element.appendChild(element2);
    }

    public final void initStyleDOM() throws IOException {
        this.styleDoc = this.createDOM("office:document-styles");
    }

    static org.w3c.dom.Document parse(DocumentBuilder documentBuilder, byte[] byArray) throws SAXException, IOException {
        org.w3c.dom.Document document = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Reader reader = OfficeDocument.hack(byteArrayInputStream);
        InputSource inputSource = new InputSource(reader);
        document = documentBuilder.parse(inputSource);
        return document;
    }

    public void read(InputStream inputStream) throws IOException {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        Debug.log(1, "reading Office file");
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OfficeDocumentException(parserConfigurationException);
        }
        this.zip = new OfficeZip();
        this.zip.read(inputStream);
        byte[] byArray4 = this.zip.getContentXMLBytes();
        if (byArray4 == null) {
            throw new OfficeDocumentException("Entry content.xml not found in file");
        }
        try {
            this.contentDoc = OfficeDocument.parse(documentBuilder, byArray4);
        }
        catch (SAXException sAXException) {
            throw new OfficeDocumentException(sAXException);
        }
        byte[] byArray5 = this.zip.getStyleXMLBytes();
        if (byArray5 != null) {
            try {
                this.styleDoc = OfficeDocument.parse(documentBuilder, byArray5);
            }
            catch (SAXException sAXException) {
                throw new OfficeDocumentException(sAXException);
            }
        }
        if ((byArray3 = this.zip.getMetaXMLBytes()) != null) {
            try {
                this.metaDoc = OfficeDocument.parse(documentBuilder, byArray3);
            }
            catch (SAXException sAXException) {
                throw new OfficeDocumentException(sAXException);
            }
        }
        if ((byArray2 = this.zip.getSettingsXMLBytes()) != null) {
            try {
                this.settingsDoc = OfficeDocument.parse(documentBuilder, byArray2);
            }
            catch (SAXException sAXException) {
                throw new OfficeDocumentException(sAXException);
            }
        }
        if ((byArray = this.zip.getManifestXMLBytes()) != null) {
            try {
                this.manifestDoc = OfficeDocument.parse(documentBuilder, byArray);
            }
            catch (SAXException sAXException) {
                throw new OfficeDocumentException(sAXException);
            }
        }
    }

    public void read(InputStream inputStream, boolean bl) throws IOException {
        Debug.log(1, "reading Office file");
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OfficeDocumentException(parserConfigurationException);
        }
        if (bl) {
            this.read(inputStream);
        } else {
            try {
                Element element;
                Reader reader = OfficeDocument.secondHack(inputStream);
                InputSource inputSource = new InputSource(reader);
                org.w3c.dom.Document document = documentBuilder.parse(inputSource);
                Element element2 = element = document.getDocumentElement();
                if (document != null) {
                    Node node;
                    this.contentDoc = this.createDOM("office:document-content");
                    element2 = element = this.contentDoc.getDocumentElement();
                    NodeList nodeList = document.getElementsByTagName("office:font-decls");
                    if (nodeList.getLength() > 0) {
                        node = this.contentDoc.importNode(nodeList.item(0), true);
                        element2.appendChild(node);
                    }
                    if ((nodeList = document.getElementsByTagName("office:automatic-styles")).getLength() > 0) {
                        node = this.contentDoc.importNode(nodeList.item(0), true);
                        element2.appendChild(node);
                    }
                    if ((nodeList = document.getElementsByTagName("office:body")).getLength() > 0) {
                        node = this.contentDoc.importNode(nodeList.item(0), true);
                        element2.appendChild(node);
                    }
                    this.styleDoc = this.createDOM("office:document-styles");
                    element2 = element = this.styleDoc.getDocumentElement();
                    nodeList = document.getElementsByTagName("office:font-decls");
                    if (nodeList.getLength() > 0) {
                        node = this.styleDoc.importNode(nodeList.item(0), true);
                        element2.appendChild(node);
                    }
                    if ((nodeList = document.getElementsByTagName("office:styles")).getLength() > 0) {
                        node = this.styleDoc.importNode(nodeList.item(0), true);
                        element2.appendChild(node);
                    }
                    if ((nodeList = document.getElementsByTagName("office:automatic-styles")).getLength() > 0) {
                        node = this.styleDoc.importNode(nodeList.item(0), true);
                        element2.appendChild(node);
                    }
                    if ((nodeList = document.getElementsByTagName("office:master-styles")).getLength() > 0) {
                        node = this.styleDoc.importNode(nodeList.item(0), true);
                        element2.appendChild(node);
                    }
                    this.settingsDoc = this.createDOM("office:document-settings");
                    element2 = element = this.settingsDoc.getDocumentElement();
                    nodeList = document.getElementsByTagName("office:settings");
                    if (nodeList.getLength() > 0) {
                        node = this.settingsDoc.importNode(nodeList.item(0), true);
                        element2.appendChild(node);
                    }
                    this.metaDoc = this.createDOM("office:document-meta");
                    element2 = element = this.metaDoc.getDocumentElement();
                    nodeList = document.getElementsByTagName("office:meta");
                    if (nodeList.getLength() > 0) {
                        node = this.metaDoc.importNode(nodeList.item(0), true);
                        element2.appendChild(node);
                    }
                }
            }
            catch (SAXException sAXException) {
                throw new OfficeDocumentException(sAXException);
            }
        }
    }

    private static Reader secondHack(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        char[] cArray = new char[inputStream.available()];
        bufferedReader.read(cArray, 0, inputStream.available());
        String string = new String(cArray);
        StringBuffer stringBuffer = new StringBuffer(inputStream.available());
        int n = string.lastIndexOf("</office:document>");
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append("</office:document>");
        StringReader stringReader = new StringReader(stringBuffer.toString());
        return stringReader;
    }

    public void setContentDOM(Node node) {
        this.contentDoc = (org.w3c.dom.Document)node;
    }

    public void setMetaDOM(Node node) {
        this.metaDoc = (org.w3c.dom.Document)node;
    }

    public void setSettingsDOM(Node node) {
        this.settingsDoc = (org.w3c.dom.Document)node;
    }

    public void setStyleDOM(Node node) {
        this.styleDoc = (org.w3c.dom.Document)node;
    }

    private String trimDocumentName(String string) {
        String string2;
        String string3 = string.toLowerCase();
        if (string3.endsWith(string2 = this.getFileExtension())) {
            int n = string.length();
            int n2 = n - string2.length();
            string = string.substring(0, n2);
        }
        return string;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.zip == null) {
            this.zip = new OfficeZip();
        }
        this.initManifestDOM();
        Element element = this.manifestDoc.getDocumentElement();
        Iterator iterator = this.getEmbeddedObjects();
        while (iterator.hasNext()) {
            EmbeddedObject embeddedObject = (EmbeddedObject)iterator.next();
            embeddedObject.writeManifestData(this.manifestDoc);
            embeddedObject.write(this.zip);
        }
        Element element2 = this.manifestDoc.createElement("manifest:file-entry");
        element2.setAttribute("manifest:full-path", "Pictures/");
        element2.setAttribute("manifest:media-type", "");
        element.appendChild(element2);
        this.zip.setContentXMLBytes(OfficeDocument.docToBytes(this.contentDoc));
        element2 = this.manifestDoc.createElement("manifest:file-entry");
        element2.setAttribute("manifest:full-path", "content.xml");
        element2.setAttribute("manifest:media-type", "text/xml");
        element.appendChild(element2);
        if (this.styleDoc != null) {
            this.zip.setStyleXMLBytes(OfficeDocument.docToBytes(this.styleDoc));
            element2 = this.manifestDoc.createElement("manifest:file-entry");
            element2.setAttribute("manifest:full-path", "styles.xml");
            element2.setAttribute("manifest:media-type", "text/xml");
            element.appendChild(element2);
        }
        if (this.metaDoc != null) {
            this.zip.setMetaXMLBytes(OfficeDocument.docToBytes(this.metaDoc));
            element2 = this.manifestDoc.createElement("manifest:file-entry");
            element2.setAttribute("manifest:full-path", "meta.xml");
            element2.setAttribute("manifest:media-type", "text/xml");
            element.appendChild(element2);
        }
        if (this.settingsDoc != null) {
            this.zip.setSettingsXMLBytes(OfficeDocument.docToBytes(this.settingsDoc));
            element2 = this.manifestDoc.createElement("manifest:file-entry");
            element2.setAttribute("manifest:full-path", "settings.xml");
            element2.setAttribute("manifest:media-type", "text/xml");
            element.appendChild(element2);
        }
        this.zip.setManifestXMLBytes(OfficeDocument.docToBytes(this.manifestDoc));
        this.zip.write(outputStream);
    }

    public void write(OutputStream outputStream, boolean bl) throws IOException {
        if (bl) {
            this.write(outputStream);
        } else {
            try {
                Node node;
                NodeList nodeList;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
                DocumentType documentType = dOMImplementation.createDocumentType("office:document", "-//OpenOffice.org//DTD OfficeDocument 1.0//EN", null);
                org.w3c.dom.Document document = dOMImplementation.createDocument("http://openoffice.org/2000/office", "office:document", null);
                Element element = document.getDocumentElement();
                element.setAttribute("xmlns:office", "http://openoffice.org/2000/office");
                element.setAttribute("xmlns:style", "http://openoffice.org/2000/style");
                element.setAttribute("xmlns:text", "http://openoffice.org/2000/text");
                element.setAttribute("xmlns:table", "http://openoffice.org/2000/table");
                element.setAttribute("xmlns:draw", "http://openoffice.org/2000/drawing");
                element.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
                element.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
                element.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
                element.setAttribute("xmlns:meta", "http://openoffice.org/2000/meta");
                element.setAttribute("xmlns:number", "http://openoffice.org/2000/datastyle");
                element.setAttribute("xmlns:svg", "http://www.w3.org/2000/svg");
                element.setAttribute("xmlns:chart", "http://openoffice.org/2000/chart");
                element.setAttribute("xmlns:dr3d", "http://openoffice.org/2000/dr3d");
                element.setAttribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
                element.setAttribute("xmlns:form", "http://openoffice.org/2000/form");
                element.setAttribute("xmlns:script", "http://openoffice.org/2000/script");
                element.setAttribute("xmlns:config", "http://openoffice.org/2001/config");
                if (this.getDocumentMimeType() == "application/vnd.sun.xml.calc") {
                    element.setAttribute("office:class", "spreadsheet");
                } else if (this.getDocumentMimeType() == "application/vnd.sun.xml.writer") {
                    element.setAttribute("office:class", "text");
                }
                element.setAttribute("office:version", "1.0");
                Element element2 = element;
                if (this.metaDoc != null && (nodeList = this.metaDoc.getElementsByTagName("office:meta")).getLength() > 0) {
                    node = document.importNode(nodeList.item(0), true);
                    element2.appendChild(node);
                }
                if (this.styleDoc != null && (nodeList = this.styleDoc.getElementsByTagName("office:styles")).getLength() > 0) {
                    node = document.importNode(nodeList.item(0), true);
                    element2.appendChild(node);
                }
                if (this.settingsDoc != null && (nodeList = this.settingsDoc.getElementsByTagName("office:settings")).getLength() > 0) {
                    node = document.importNode(nodeList.item(0), true);
                    element2.appendChild(node);
                }
                if (this.contentDoc != null) {
                    nodeList = this.contentDoc.getElementsByTagName("office:automatic-styles");
                    if (nodeList.getLength() > 0) {
                        node = document.importNode(nodeList.item(0), true);
                        element2.appendChild(node);
                    }
                    if ((nodeList = this.contentDoc.getElementsByTagName("office:body")).getLength() > 0) {
                        node = document.importNode(nodeList.item(0), true);
                        element2.appendChild(node);
                    }
                }
                byte[] byArray = OfficeDocument.docToBytes(document);
                outputStream.write(byArray);
            }
            catch (Exception exception) {
                System.out.println("\nException in OfficeDocument.write():" + exception);
            }
        }
    }
}

