/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel;

import java.io.IOException;
import java.util.Vector;
import org.openoffice.xmerge.converter.xml.sxc.BookSettings;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.SpreadsheetEncoder;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.util.Debug;

final class PocketExcelEncoder
extends SpreadsheetEncoder {
    private Workbook wb;

    PocketExcelEncoder(String string, String string2) throws IOException {
        super(string, string2);
        this.wb = new Workbook(string);
    }

    public void addCell(int n, int n2, Format format, String string) throws IOException {
        if (string.startsWith("=")) {
            string = this.parseFormula(string);
            Debug.log((int)4, (String)("Parsing Formula " + string));
        }
        this.wb.addCell(n, n2, format, string);
    }

    public void addSettings(BookSettings bookSettings) throws IOException {
        this.wb.addSettings(bookSettings);
    }

    public void createWorksheet(String string) throws IOException {
        this.wb.addWorksheet(string);
    }

    public int getNumberOfSheets() {
        Vector vector = this.wb.getWorksheetNames();
        return vector.size();
    }

    public String getSheetName(int n) {
        Vector vector = this.wb.getWorksheetNames();
        String string = (String)vector.elementAt(n);
        return string;
    }

    public Workbook getWorkbook() throws IOException {
        return this.wb;
    }

    protected String parseFormula(String string) {
        Debug.log((int)4, (String)("Strip Formula (Before) : " + string));
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            switch (stringBuffer.charAt(n2)) {
                case '[': {
                    Debug.log((int)4, (String)"brace Found");
                    bl = true;
                    bl2 = true;
                    break;
                }
                case ']': {
                    bl = false;
                    break;
                }
                case '.': {
                    if (bl && (bl2 || bl3)) {
                        Debug.log((int)4, (String)"dot Found and in brace");
                        bl2 = false;
                        bl3 = false;
                        break;
                    }
                    if (bl3) {
                        bl3 = false;
                        break;
                    }
                    stringBuffer2.append(stringBuffer.charAt(n2));
                    break;
                }
                case ':': {
                    bl3 = true;
                    stringBuffer2.append(stringBuffer.charAt(n2));
                    break;
                }
                case ';': {
                    stringBuffer2.append(',');
                    break;
                }
                default: {
                    stringBuffer2.append(stringBuffer.charAt(n2));
                    bl2 = false;
                    break;
                }
            }
            ++n2;
        }
        Debug.log((int)4, (String)("Strip Formula (After) : " + stringBuffer2));
        return stringBuffer2.toString();
    }

    public void setCellFormat(int n, int n2, Format format) {
        Debug.log((int)4, (String)("bold : " + format.getAttribute(1) + ",Italic : " + format.getAttribute(2) + ",Underline : " + format.getAttribute(4)));
    }

    public void setColumnRows(Vector vector) throws IOException {
        this.wb.addColInfo(vector);
    }

    private long setFormatString(long l) {
        return 0L;
    }

    public void setNameDefinition(NameDefinition nameDefinition) throws IOException {
        String string = nameDefinition.getDefinition();
        nameDefinition.setDefinition(this.parseFormula(string));
        this.wb.addNameDefinition(nameDefinition);
    }
}

