/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.TestBase;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiServiceFactory;
import helper.APIDescGetter;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import lib.TestResult;
import share.DescEntry;
import share.DescGetter;
import share.LogWriter;
import stats.Summarizer;
import util.DynamicClassLoader;

public class java_fat_service
implements TestBase {
    protected static boolean debug = false;
    protected LogWriter log = null;

    public boolean executeTest(TestParameters testParameters) {
        int n;
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader();
        this.log = (LogWriter)dynamicClassLoader.getInstance((String)testParameters.get("LogWriter"));
        debug = (Boolean)testParameters.get("DebugIsActive");
        APIDescGetter aPIDescGetter = new APIDescGetter();
        String string = (String)testParameters.get("TestJob");
        boolean bl = true;
        this.log.println("Getting Descriptions for Job: " + string);
        DescEntry[] descEntryArray = ((DescGetter)aPIDescGetter).getDescriptionFor(string, (String)testParameters.get("DescriptionPath"), debug);
        if (descEntryArray == null) {
            this.log.println("Couldn't get Description for Job");
            return false;
        }
        String string2 = (String)testParameters.get("ConnectionString");
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        for (n = 0; n < descEntryArray.length; ++n) {
            LogWriter logWriter;
            Object object;
            if (descEntryArray[n] == null) continue;
            if (descEntryArray[n].hasErrorMsg) {
                this.log.println(descEntryArray[n].ErrorMsg);
                continue;
            }
            DescEntry descEntry = descEntryArray[n];
            Summarizer summarizer = new Summarizer();
            TestCase testCase = null;
            try {
                testCase = (TestCase)dynamicClassLoader.getInstance("mod._" + descEntry.entryName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                descEntry.ErrorMsg = illegalArgumentException.getMessage();
                descEntry.hasErrorMsg = true;
            }
            if (testCase == null) {
                Summarizer.summarizeDown(descEntry, descEntry.ErrorMsg);
                object = (LogWriter)dynamicClassLoader.getInstance((String)testParameters.get("OutProducer"));
                object.initialize(descEntry, true);
                descEntry.UserDefinedParams = testParameters;
                object.summary(descEntry);
                continue;
            }
            this.log.println("Creating: " + testCase.getObjectName());
            this.log.initialize(descEntry, true);
            descEntry.UserDefinedParams = testParameters;
            object = null;
            try {
                testCase.setLogWriter((PrintWriter)((Object)this.log));
                testCase.initializeTestCase(testParameters);
                object = testCase.getTestEnvironment(testParameters);
            }
            catch (Exception exception) {
                this.log.println("Exception while creating " + testCase.getObjectName());
                this.log.println("Exception: " + exception);
                this.log.println("Message " + exception.getMessage());
                object = null;
            }
            if (object == null) {
                Summarizer.summarizeDown(descEntry, "Couldn't create " + testCase.getObjectName());
                logWriter = (LogWriter)dynamicClassLoader.getInstance((String)testParameters.get("OutProducer"));
                logWriter.initialize(descEntry, true);
                descEntry.UserDefinedParams = testParameters;
                logWriter.summary(descEntry);
                continue;
            }
            this.log.println("Created " + testCase.getObjectName() + "\n");
            for (int i = 0; i < descEntry.SubEntryCount; ++i) {
                if (!descEntry.SubEntries[i].isToTest) {
                    Summarizer.summarizeDown(descEntry.SubEntries[i], "not part of the job");
                    continue;
                }
                this.log.println("running: " + descEntry.SubEntries[i].entryName);
                LogWriter logWriter2 = (LogWriter)dynamicClassLoader.getInstance((String)testParameters.get("LogWriter"));
                logWriter2.initialize(descEntry.SubEntries[i], true);
                descEntry.SubEntries[i].UserDefinedParams = testParameters;
                descEntry.SubEntries[i].Logger = logWriter2;
                if (object == null || ((TestEnvironment)object).isDisposed()) {
                    object = this.getEnv(descEntry, testParameters);
                }
                MultiMethodTest multiMethodTest = null;
                TestResult testResult = null;
                try {
                    multiMethodTest = (MultiMethodTest)dynamicClassLoader.getInstance(descEntry.SubEntries[i].entryName);
                    testResult = multiMethodTest.run(descEntry.SubEntries[i], (TestEnvironment)object, testParameters);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log.println("Couldn't load class " + descEntry.SubEntries[i].entryName);
                    this.log.println("**** " + illegalArgumentException.getMessage() + " ****");
                    Summarizer.summarizeDown(descEntry.SubEntries[i], illegalArgumentException.getMessage());
                }
                catch (RuntimeException runtimeException) {
                    object = this.getEnv(descEntry, testParameters);
                    multiMethodTest = (MultiMethodTest)dynamicClassLoader.getInstance(descEntry.SubEntries[i].entryName);
                    testResult = object != null && multiMethodTest != null ? multiMethodTest.run(descEntry.SubEntries[i], (TestEnvironment)object, testParameters) : null;
                }
                if (testResult != null) {
                    for (int j = 0; j < descEntry.SubEntries[i].SubEntryCount; ++j) {
                        if (!testResult.hasMethod(descEntry.SubEntries[i].SubEntries[j].entryName)) continue;
                        descEntry.SubEntries[i].SubEntries[j].State = testResult.getStatusFor(descEntry.SubEntries[i].SubEntries[j].entryName).toString();
                    }
                }
                summarizer.summarizeUp(descEntry.SubEntries[i]);
                LogWriter logWriter3 = (LogWriter)dynamicClassLoader.getInstance((String)testParameters.get("OutProducer"));
                logWriter3.initialize(descEntry.SubEntries[i], true);
                descEntry.SubEntries[i].UserDefinedParams = testParameters;
                logWriter3.summary(descEntry.SubEntries[i]);
            }
            try {
                testCase.cleanupTestCase(testParameters);
            }
            catch (Exception exception) {
                exception.printStackTrace((PrintWriter)((Object)this.log));
            }
            summarizer.summarizeUp(descEntry);
            logWriter = (LogWriter)dynamicClassLoader.getInstance((String)testParameters.get("OutProducer"));
            logWriter.initialize(descEntry, true);
            logWriter.summary(descEntry);
        }
        if (descEntryArray.length > 1) {
            this.log.println("");
            n = 0;
            this.log.println("Failures that appeared during scenario execution:");
            for (int i = 0; i < descEntryArray.length; ++i) {
                if (descEntryArray[i].State.endsWith("OK")) continue;
                this.log.println("\t " + descEntryArray[i].longName);
                ++n;
            }
            this.log.println(n + " of " + descEntryArray.length + " tests failed");
        }
        return bl;
    }

    protected TestEnvironment getEnv(DescEntry descEntry, TestParameters testParameters) {
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader();
        this.log = (LogWriter)dynamicClassLoader.getInstance((String)testParameters.get("LogWriter"));
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
        TestCase testCase = null;
        try {
            testCase = (TestCase)dynamicClassLoader.getInstance("mod._" + descEntry.entryName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            descEntry.ErrorMsg = illegalArgumentException.getMessage();
            descEntry.hasErrorMsg = true;
        }
        this.log.println("Creating: " + testCase.getObjectName());
        LogWriter logWriter = (LogWriter)dynamicClassLoader.getInstance((String)testParameters.get("LogWriter"));
        logWriter.initialize(descEntry, true);
        descEntry.UserDefinedParams = testParameters;
        testCase.setLogWriter((PrintWriter)((Object)logWriter));
        TestEnvironment testEnvironment = null;
        try {
            testCase.initializeTestCase(testParameters);
            testEnvironment = testCase.getTestEnvironment(testParameters);
        }
        catch (DisposedException disposedException) {
            logWriter.println("Office disposed");
        }
        return testEnvironment;
    }

    protected void shortWait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

