/*
 * Decompiled with CFR 0.152.
 */
package complexlib;

import complexlib.MethodThread;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lib.StatusException;
import lib.TestParameters;
import share.ComplexTest;
import share.DescEntry;
import share.LogWriter;
import share.Watcher;

public abstract class ComplexTestCase
implements ComplexTest {
    protected static TestParameters param = null;
    protected static LogWriter log = null;
    protected DescEntry subEntry = null;
    protected boolean state = true;
    protected String message = null;
    protected int mThreadTimeOut = 0;
    public static final boolean CONTINUE = true;
    public static final boolean BREAK = true;

    public void executeMethods(DescEntry descEntry, TestParameters testParameters) {
        block22: {
            Object object;
            boolean bl;
            block20: {
                param = testParameters;
                log = descEntry.Logger;
                this.mThreadTimeOut = param.getInt("ThreadTimeOut");
                if (this.mThreadTimeOut == 0) {
                    this.mThreadTimeOut = 300000;
                }
                bl = true;
                try {
                    Method method = this.getClass().getMethod("before", new Class[0]);
                    method.invoke((Object)this, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    log.println("Cannot access the 'before()' method, although it is there. Is this ok?");
                }
                catch (InvocationTargetException invocationTargetException) {
                    bl = false;
                    object = invocationTargetException.getTargetException();
                    if (object instanceof RuntimeException && !this.state) break block20;
                    log.println(((Throwable)object).toString());
                    if (this.message == null) {
                        this.message = "Exception in before() method.\n\r" + ((Throwable)object).getMessage();
                    }
                    this.state = false;
                    ((Throwable)object).printStackTrace((PrintWriter)((Object)log));
                }
            }
            for (int i = 0; i < descEntry.SubEntries.length; ++i) {
                block21: {
                    this.subEntry = descEntry.SubEntries[i];
                    if (!bl) {
                        this.subEntry.State = this.message;
                        this.subEntry.hasErrorMsg = true;
                        this.subEntry.ErrorMsg = this.message;
                        continue;
                    }
                    this.state = true;
                    this.message = "";
                    object = null;
                    try {
                        object = this.getClass().getMethod(this.subEntry.entryName, new Class[0]);
                        MethodThread methodThread = new MethodThread((Method)object, this, (PrintWriter)((Object)log));
                        log.println("Starting " + ((Method)object).getName());
                        methodThread.start();
                        try {
                            int n = -1;
                            int n2 = 0;
                            int n3 = 1000;
                            int n4 = 0;
                            while (methodThread.isAlive() && (n != n2 || n4 * n3 < this.mThreadTimeOut)) {
                                Thread.sleep(n3);
                                ++n4;
                                Watcher watcher = (Watcher)param.get("Watcher");
                                if (watcher == null) continue;
                                n = n2;
                                n2 = watcher.getPing();
                                n4 = 0;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (methodThread.isAlive()) {
                            log.println("Destroy " + ((Method)object).getName());
                            methodThread.destroy();
                            this.subEntry.State = "Test did sleep for " + this.mThreadTimeOut / 1000 + " seconds and has been killed!";
                            this.subEntry.hasErrorMsg = true;
                            this.subEntry.ErrorMsg = this.subEntry.State;
                            continue;
                        }
                        log.println("Finished " + ((Method)object).getName());
                        if (methodThread.hasErrorMessage()) {
                            this.subEntry.State = methodThread.getErrorMessage();
                            this.subEntry.hasErrorMsg = true;
                            this.subEntry.ErrorMsg = this.subEntry.State;
                        }
                        break block21;
                    }
                    catch (Exception exception) {
                        log.println(exception.getClass().getName());
                        String string = exception.getMessage();
                        log.println("Message: " + string);
                        exception.printStackTrace((PrintWriter)((Object)log));
                        this.subEntry.State = "SKIPPED.FAILED";
                        this.subEntry.hasErrorMsg = true;
                        this.subEntry.ErrorMsg = string == null ? "" : string;
                    }
                    continue;
                }
                this.subEntry.State = this.state ? "PASSED.OK" : this.message;
                this.subEntry.hasErrorMsg = !this.state;
                this.subEntry.ErrorMsg = this.message;
            }
            if (bl) {
                try {
                    Method method = this.getClass().getMethod("after", new Class[0]);
                    method.invoke((Object)this, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    object = invocationTargetException.getTargetException();
                    if (object instanceof StatusException) break block22;
                    log.println(((Throwable)object).toString());
                    this.message = this.message == null ? "Exception in after() method.\n\r" + ((Throwable)object).getMessage() : this.message + "Exception in 'after()' method.\n\r" + ((Throwable)object).getMessage();
                    log.println("Message: " + this.message);
                    ((Throwable)object).printStackTrace((PrintWriter)((Object)log));
                }
            }
        }
    }

    public abstract String[] getTestMethodNames();

    public String getTestObjectName() {
        return this.getClass().getName();
    }

    protected void assure(boolean bl) {
        this.assure("Assure failed.", bl, false);
    }

    protected void assure(String string, boolean bl) {
        this.assure(string, bl, false);
    }

    protected void failed() {
        this.assure("Test did fail.", false, false);
    }

    protected void failed(String string) {
        this.assure(string, false, false);
    }

    protected void assure(String string, boolean bl, boolean bl2) {
        this.state &= bl;
        if (!bl) {
            this.message = this.message + string + "\r\n";
            log.println(string);
            if (!bl2) {
                throw new AssureException(string);
            }
        }
    }

    protected void failed(String string, boolean bl) {
        this.assure(string, false, bl);
    }

    protected void addResult(String string, boolean bl) {
        String string2 = string + " - " + bl;
        this.state &= bl;
        this.message = this.message + string2 + "\r\n";
        log.println(string2);
    }

    public class AssureException
    extends RuntimeException {
        public AssureException(String string) {
            super(string);
        }
    }
}

