/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.ConvWatchCancelException;
import convwatch.ConvWatchException;
import convwatch.FileHelper;
import convwatch.GraphicalTestArguments;
import convwatch.INIOutputter;
import convwatch.IniFile;
import convwatch.OfficePrint;
import convwatch.PRNCompare;
import convwatch.StatusHelper;
import helper.URLHelper;
import java.io.File;

public class ConvWatch {
    String getBuildID_FromFile(String string) {
        String string2 = "";
        IniFile iniFile = new IniFile(string);
        if (iniFile.is()) {
            string2 = iniFile.getKey("", "buildid");
        }
        return string2;
    }

    StatusHelper[] createPostscriptStartCheck(GraphicalTestArguments graphicalTestArguments, String string, String string2, String string3, boolean bl) throws ConvWatchCancelException {
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        if (!FileHelper.exists(string2)) {
            throw new ConvWatchCancelException("createPostscriptStartCheck: Input file: " + string2 + " does not exist.");
        }
        if (string3 == null) {
            string8 = FileHelper.getNameNoSuffix(string2);
            string3 = string8 + ".prn";
        }
        string8 = System.getProperty("file.separator");
        File file = new File(string3);
        if (file.isDirectory()) {
            string7 = FileHelper.getBasename(string2);
            string6 = FileHelper.getNameNoSuffix(string7);
            string5 = string3 + string8 + string6 + ".info";
            string3 = string3 + string8 + string6 + ".prn";
            string4 = "";
            if (FileHelper.exists(string5)) {
                string4 = this.getBuildID_FromFile(string5);
            }
            graphicalTestArguments.setRefBuildID(string4);
        } else {
            string7 = FileHelper.getBasename(string3);
            int n = string7.indexOf(46);
            if (n == -1) {
                throw new ConvWatchCancelException("createPostscriptStartCheck: Given reference directory: '" + string3 + "' does not exist.");
            }
        }
        if (!FileHelper.exists(string3)) {
            throw new ConvWatchCancelException("createPostscriptStartCheck: Given reference file: " + string3 + " does not exist.");
        }
        FileHelper.makeDirectories("", string);
        string7 = URLHelper.getFileURLFromSystemPath(string2);
        string6 = FileHelper.getBasename(string2);
        string5 = FileHelper.getNameNoSuffix(string6);
        string4 = string + string8 + string6;
        String string9 = URLHelper.getFileURLFromSystemPath(string4);
        String string10 = FileHelper.getBasename(string3);
        String string11 = FileHelper.getNameNoSuffix(string10);
        String string12 = string11 + ".ps";
        String string13 = string + string8 + string12;
        String string14 = URLHelper.getFileURLFromSystemPath(string13);
        OfficePrint.printToFile(graphicalTestArguments, string7, string9, string14);
        if (!FileHelper.exists(string13)) {
            throw new ConvWatchCancelException("createPostscriptStartCheck: Printed file " + string13 + " does not exist.");
        }
        PRNCompare pRNCompare = new PRNCompare();
        String string15 = FileHelper.getPath(string2);
        String string16 = FileHelper.getPath(string3);
        pRNCompare.setInputPath(string15);
        pRNCompare.setReferencePath(string16);
        pRNCompare.setOutputPath(string);
        pRNCompare.setReferenceFile(string10);
        pRNCompare.setPostScriptFile(string12);
        if (graphicalTestArguments.printAllPages()) {
            pRNCompare.setMaxPages(9999);
        } else {
            if (graphicalTestArguments.getMaxPages() > 0) {
                pRNCompare.setMaxPages(graphicalTestArguments.getMaxPages());
            }
            if (graphicalTestArguments.getOnlyPages().length() != 0) {
                pRNCompare.setMaxPages(9999);
            }
        }
        pRNCompare.setResolutionInDPI(graphicalTestArguments.getResolutionInDPI());
        pRNCompare.setBorderMove(bl);
        StatusHelper[] statusHelperArray = pRNCompare.compare();
        return statusHelperArray;
    }

    static boolean createINIStatus(StatusHelper[] statusHelperArray, String string, String string2, String string3, String string4, String string5) {
        String string6 = System.getProperty("file.separator");
        String string7 = FileHelper.getBasename(string3);
        String string8 = FileHelper.getNameNoSuffix(string7);
        String string9 = string + string8 + ".ini";
        INIOutputter iNIOutputter = INIOutputter.create(string2, string9, "", "");
        iNIOutputter.createHeader();
        iNIOutputter.writeSection("global");
        iNIOutputter.writeValue("pages", String.valueOf(statusHelperArray.length));
        iNIOutputter.writeValue("buildid", string4);
        iNIOutputter.writeValue("refbuildid", string5);
        iNIOutputter.writeValue("diffdiff", "no");
        iNIOutputter.writeValue("basename", string7);
        boolean bl = true;
        for (int i = 0; i < statusHelperArray.length; ++i) {
            iNIOutputter.writeSection("page" + String.valueOf(i + 1));
            statusHelperArray[i].printStatus();
            boolean bl2 = true;
            int n = statusHelperArray[i].nDiffStatus;
            if (!(n == 2 || n == 3 && statusHelperArray[i].nPercent < 5 || n == 4 || n == 5 && statusHelperArray[i].nPercent2 < 5)) {
                bl2 = false;
            }
            iNIOutputter.checkLine(statusHelperArray[i], bl2);
            bl &= bl2;
        }
        iNIOutputter.close();
        return bl;
    }

    static void createINIStatus_DiffDiff(StatusHelper[] statusHelperArray, String string, String string2, String string3, String string4) {
        String string5 = System.getProperty("file.separator");
        String string6 = FileHelper.getBasename(string3);
        String string7 = FileHelper.getNameNoSuffix(string6);
        String string8 = string + string7 + ".ini";
        INIOutputter iNIOutputter = INIOutputter.create(string2, string8, string, "");
        iNIOutputter.createHeader();
        iNIOutputter.writeSection("global");
        iNIOutputter.writeValue("pages", String.valueOf(statusHelperArray.length));
        iNIOutputter.writeValue("buildid", string4);
        iNIOutputter.writeValue("diffdiff", "yes");
        iNIOutputter.writeValue("basename", string6);
        for (int i = 0; i < statusHelperArray.length; ++i) {
            iNIOutputter.writeSection("page" + String.valueOf(i + 1));
            boolean bl = statusHelperArray[i].nDiffStatus == 2;
            iNIOutputter.checkDiffDiffLine(statusHelperArray[i], bl);
        }
        iNIOutputter.close();
    }

    public static boolean check(GraphicalTestArguments graphicalTestArguments, String string, String string2, String string3) throws ConvWatchCancelException, ConvWatchException {
        ConvWatch convWatch = new ConvWatch();
        StatusHelper[] statusHelperArray = convWatch.createPostscriptStartCheck(graphicalTestArguments, string, string2, string3, graphicalTestArguments.isBorderMove());
        boolean bl = ConvWatch.createINIStatus(statusHelperArray, "", string, string2, graphicalTestArguments.getBuildID(), graphicalTestArguments.getRefBuildID());
        if (!bl) {
            throw new ConvWatchException("File compare failed with file " + string2);
        }
        return bl;
    }

    public static boolean checkDiffDiff(GraphicalTestArguments graphicalTestArguments, String string, String string2, String string3, String string4) throws ConvWatchCancelException, ConvWatchException {
        ConvWatch convWatch = new ConvWatch();
        StatusHelper[] statusHelperArray = convWatch.createPostscriptStartCheck(graphicalTestArguments, string, string2, string3, false);
        boolean bl = ConvWatch.createINIStatus(statusHelperArray, "", string, string2, graphicalTestArguments.getBuildID(), graphicalTestArguments.getRefBuildID());
        StatusHelper[] statusHelperArray2 = new StatusHelper[statusHelperArray.length];
        String string5 = System.getProperty("file.separator");
        boolean bl2 = true;
        boolean bl3 = false;
        PRNCompare pRNCompare = new PRNCompare();
        for (int i = 0; i < statusHelperArray.length; ++i) {
            String string6 = statusHelperArray[i].m_sDiffGfx;
            String string7 = FileHelper.getBasename(string6);
            String string8 = string4 + string5 + string7;
            if (!FileHelper.exists(string8)) {
                System.out.println("checkDiffDiff: Old diff file: '" + string8 + "' does not exist.");
                continue;
            }
            String string9 = FileHelper.getPath(string6);
            String string10 = string7;
            String string11 = string4;
            String string12 = string7;
            StatusHelper statusHelper = pRNCompare.checkDiffDiff(string, string9, string10, string11, string12);
            boolean bl4 = statusHelper.nDiffStatus == 2;
            bl2 &= bl4;
            bl3 = true;
            statusHelperArray2[i] = statusHelper;
        }
        ConvWatch.createINIStatus_DiffDiff(statusHelperArray2, "DiffDiff_", string, string2, graphicalTestArguments.getBuildID());
        if (!bl3) {
            throw new ConvWatchCancelException("No old diff file found.");
        }
        if (!bl2) {
            throw new ConvWatchException("File diff diff compare failed with file " + string2);
        }
        return bl2;
    }
}

