/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.db;

import com.sun.xmlsearch.db.Block;
import com.sun.xmlsearch.db.BlockFactory;
import com.sun.xmlsearch.db.BlockManager;
import com.sun.xmlsearch.db.VectorBtree;
import com.sun.xmlsearch.db.VectorBtreeParameters;

public class FullVectorBtree
extends VectorBtree {
    private static final int MaxVeclen = 128;
    private static final double SplitRatio = 0.5;

    protected FullVectorBtree() {
    }

    public FullVectorBtree(VectorBtreeParameters vectorBtreeParameters, boolean bl) throws Exception {
        this._params = vectorBtreeParameters;
        this._vecLen = vectorBtreeParameters.getVectorLength();
        this._blockSize = vectorBtreeParameters.getBlockSize();
        this._blockManager = new BlockManager(vectorBtreeParameters, bl, new BlockFactory(){

            public Block makeBlock() {
                return new FullVectorBlock(FullVectorBtree.this._blockSize);
            }
        });
        this._maxEntries = (this._blockSize - 8 - 4) / (this._vecLen + 4);
        if ((this._maxEntries & 1) == 0) {
            --this._maxEntries;
        }
        this._leafDataLimit = this._blockSize - this._vecLen - 8 - 4;
        this._vectorsOffset = (this._maxEntries + 1) * 4;
        this._root = this.accessBlock(vectorBtreeParameters.getRootPosition());
    }

    public boolean insertVector(byte[] byArray) throws Exception {
        if (((FullVectorBlock)this._root).isFull()) {
            FullVectorBlock fullVectorBlock = this.getNewBlock();
            this.lock(fullVectorBlock);
            this.enableModif(fullVectorBlock);
            fullVectorBlock._isLeaf = false;
            fullVectorBlock._free = 0;
            fullVectorBlock.setIntegerAt(0, this._root._number);
            this.declareModif(fullVectorBlock);
            fullVectorBlock.splitChild(0, (FullVectorBlock)this._root, this.getNewBlock());
            fullVectorBlock.setIntegerAt(0, this._root._number);
            this.unlock(this._root);
            this._params.setRoot(fullVectorBlock._number);
            this._root = fullVectorBlock;
            this.lock(fullVectorBlock);
        }
        return this.treeInsertNonfullRoot(byArray);
    }

    private boolean treeInsertNonfull(FullVectorBlock fullVectorBlock, byte[] byArray) throws Exception {
        if (fullVectorBlock._isLeaf) {
            return fullVectorBlock.insertVector(byArray);
        }
        int n = fullVectorBlock.findIndex(byArray);
        if (n < 0) {
            return true;
        }
        this.lock(fullVectorBlock);
        FullVectorBlock fullVectorBlock2 = (FullVectorBlock)this.accessChild(fullVectorBlock, n);
        if (fullVectorBlock2.isFull()) {
            this.lock(fullVectorBlock2);
            fullVectorBlock.splitChild(n, fullVectorBlock2, this.getNewBlock());
            this.unlock(fullVectorBlock2);
            if (FullVectorBtree.memcmp(byArray, fullVectorBlock._data, this.vector(n), this._vecLen) > 0) {
                fullVectorBlock2 = (FullVectorBlock)this.accessChild(fullVectorBlock, n + 1);
            }
        }
        this.unlock(fullVectorBlock);
        return this.treeInsertNonfull(fullVectorBlock2, byArray);
    }

    private boolean treeInsertNonfullRoot(byte[] byArray) throws Exception {
        if (this._root._isLeaf) {
            return ((FullVectorBlock)this._root).insertVector(byArray);
        }
        int n = this._root.findIndex(byArray);
        if (n < 0) {
            return true;
        }
        FullVectorBlock fullVectorBlock = (FullVectorBlock)this.accessChild(this._root, n);
        if (fullVectorBlock.isFull()) {
            this.lock(fullVectorBlock);
            ((FullVectorBlock)this._root).splitChild(n, fullVectorBlock, this.getNewBlock());
            this.unlock(fullVectorBlock);
            if (FullVectorBtree.memcmp(byArray, this._root._data, this.vector(n), this._vecLen) > 0) {
                fullVectorBlock = (FullVectorBlock)this.accessChild(this._root, n + 1);
            }
        }
        return this.treeInsertNonfull(fullVectorBlock, byArray);
    }

    private FullVectorBlock getNewBlock() throws Exception {
        return (FullVectorBlock)this._blockManager.getNewBlock();
    }

    private void enableModif(Block block) {
    }

    private void declareModif(Block block) {
        this._blockManager.setModified(block._number);
    }

    public void close() throws Exception {
        this._blockManager.close();
    }

    protected class FullVectorBlock
    extends VectorBtree.VectorBlock {
        public FullVectorBlock(int n) {
            super(FullVectorBtree.this, n);
        }

        public boolean isFull() {
            return this._isLeaf ? this._free > FullVectorBtree.this._leafDataLimit : this._free == FullVectorBtree.this._maxEntries;
        }

        private boolean insertVector(byte[] byArray) {
            int n = 0;
            int n2 = 0;
            while (true) {
                block10: {
                    int n3;
                    if (this._data[n] == n2) {
                        n3 = this._data[n] & 0xFF;
                        int n4 = n + 1;
                        while (n3 < FullVectorBtree.this._vecLen) {
                            if (byArray[n3] != this._data[n4]) {
                                if ((byArray[n3] & 0xFF) < (this._data[n4] & 0xFF)) {
                                    int n5 = FullVectorBtree.this._vecLen + 1 - n2;
                                    FullVectorBtree.this.enableModif(this);
                                    System.arraycopy(this._data, n4, this._data, n4 + n5, this._free - n4 + 1);
                                    for (n3 = n2; n3 < FullVectorBtree.this._vecLen; ++n3) {
                                        this._data[n4++] = byArray[n3];
                                    }
                                    this._data[n4] = (byte)n2;
                                    this._free += n5;
                                    FullVectorBtree.this.declareModif(this);
                                    return true;
                                }
                                break block10;
                            }
                            ++n2;
                            ++n3;
                            ++n4;
                        }
                        if (n3 == FullVectorBtree.this._vecLen) {
                            return true;
                        }
                    } else if (this._data[n] < n2) {
                        int n6 = FullVectorBtree.this._vecLen + 1 - n2;
                        FullVectorBtree.this.enableModif(this);
                        System.arraycopy(this._data, n, this._data, n + n6, this._free - n + 1);
                        this._data[n] = (byte)n2;
                        for (n3 = n2; n3 < FullVectorBtree.this._vecLen; ++n3) {
                            this._data[++n] = byArray[n3];
                        }
                        this._free += n6;
                        FullVectorBtree.this.declareModif(this);
                        return true;
                    }
                }
                n += FullVectorBtree.this._vecLen + 1 - this._data[n];
            }
        }

        private void splitBlockInt(FullVectorBlock fullVectorBlock, int n, FullVectorBlock fullVectorBlock2) {
            int n2 = (int)((double)this._free * 0.5);
            int n3 = this._free - n2 - 1;
            FullVectorBtree.this.enableModif(fullVectorBlock2);
            fullVectorBlock2._isLeaf = false;
            fullVectorBlock2._free = 0;
            System.arraycopy(this._data, FullVectorBtree.this.vector(n2), fullVectorBlock._data, FullVectorBtree.this.vector(n), FullVectorBtree.this._vecLen);
            System.arraycopy(this._data, FullVectorBtree.this.vector(n2 + 1), fullVectorBlock2._data, FullVectorBtree.this.vector(0), FullVectorBtree.this._vecLen * n3);
            System.arraycopy(this._data, 4 * (n2 + 1), fullVectorBlock2._data, 0, 4 * (n3 + 1));
            fullVectorBlock2._free = n3;
            FullVectorBtree.this.enableModif(this);
            this._free = n2;
            FullVectorBtree.this.declareModif(this);
            FullVectorBtree.this.declareModif(fullVectorBlock2);
        }

        private boolean splitBlock(FullVectorBlock fullVectorBlock, int n, FullVectorBlock fullVectorBlock2) {
            int n2;
            int n3 = 0;
            byte[] byArray = new byte[128];
            FullVectorBtree.this.enableModif(fullVectorBlock2);
            fullVectorBlock2._isLeaf = true;
            fullVectorBlock2._free = 0;
            fullVectorBlock2._data[0] = -1;
            VectorBtree.assert(this._free > 0 && this._free <= FullVectorBtree.this._blockSize);
            int n4 = 0;
            for (n2 = 0; n2 < this._free; n2 += FullVectorBtree.this._vecLen + 1 - (this._data[n2] & 0xFF)) {
                ++n4;
            }
            int n5 = (int)((double)n4 * 0.5 + 1.0);
            n2 = 0;
            for (n4 = 0; n4 < n5; ++n4) {
                System.arraycopy(this._data, n2 + 1, byArray, this._data[n2], FullVectorBtree.this._vecLen - this._data[n2]);
                n3 = n2;
                n2 += FullVectorBtree.this._vecLen + 1 - this._data[n2];
            }
            FullVectorBtree.this.enableModif(this);
            System.arraycopy(byArray, 0, fullVectorBlock._data, FullVectorBtree.this.vector(n), FullVectorBtree.this._vecLen);
            System.arraycopy(this._data, n2 + 1, byArray, this._data[n2], FullVectorBtree.this._vecLen - this._data[n2]);
            fullVectorBlock2.insertVector(byArray);
            n2 += FullVectorBtree.this._vecLen + 1 - (this._data[n2] & 0xFF);
            FullVectorBtree.this.enableModif(fullVectorBlock2);
            System.arraycopy(this._data, n2, fullVectorBlock2._data, fullVectorBlock2._free, this._free - n2 + 1);
            fullVectorBlock2._free = this._free - n2 + FullVectorBtree.this._vecLen + 1;
            fullVectorBlock2._data[fullVectorBlock2._free] = -1;
            this._free = n3;
            this._data[this._free] = -1;
            FullVectorBtree.this.declareModif(this);
            FullVectorBtree.this.declareModif(fullVectorBlock2);
            return true;
        }

        private void splitChild(int n, FullVectorBlock fullVectorBlock, FullVectorBlock fullVectorBlock2) {
            int n2 = this._free - n;
            FullVectorBtree.this.enableModif(this);
            System.arraycopy(this._data, FullVectorBtree.this.vector(n), this._data, FullVectorBtree.this.vector(n + 1), FullVectorBtree.this._vecLen * n2);
            System.arraycopy(this._data, 4 * n, this._data, 4 * (n + 1), 4 * (n2 + 1));
            if (fullVectorBlock._isLeaf) {
                fullVectorBlock.splitBlock(this, n, fullVectorBlock2);
            } else {
                fullVectorBlock.splitBlockInt(this, n, fullVectorBlock2);
            }
            this.setIntegerAt(4 * (n + 1), fullVectorBlock2._number);
            ++this._free;
            FullVectorBtree.this.declareModif(this);
        }
    }
}

