/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.qe;

import com.sun.xmlsearch.qe.QueryHit;
import java.util.Vector;

class HitStoreNode {
    private int _free = 0;
    private int _size;
    private QueryHit[] _array;
    private int _hitCount = 0;
    private double _divider = 0.0;
    private double _min = 1.0E7;
    private double _max = 0.0;
    private HitStoreNode[] _children = new HitStoreNode[2];
    private int _index = 0;

    public HitStoreNode(int n) {
        this._size = n;
        this._array = new QueryHit[this._size];
    }

    public QueryHit getNextHit() {
        return this._index < this._free ? this._array[this._index++] : null;
    }

    private void fastAdd(QueryHit queryHit) {
        ++this._hitCount;
        this._divider += queryHit.getScore();
        if (queryHit.getScore() > this._max) {
            this._max = queryHit.getScore();
        } else if (queryHit.getScore() < this._min) {
            this._min = queryHit.getScore();
        }
        this._array[this._free++] = queryHit;
    }

    public boolean add(QueryHit queryHit) {
        if (this._array != null) {
            if (this._free < this._size) {
                this.fastAdd(queryHit);
                return false;
            }
            if (this._min != this._max) {
                this.split();
                ++this._hitCount;
                this._children[queryHit.getScore() > this._divider ? 1 : 0].fastAdd(queryHit);
                return true;
            }
            QueryHit[] queryHitArray = new QueryHit[this._size *= 2];
            System.arraycopy(this._array, 0, queryHitArray, 0, this._free);
            this._array = queryHitArray;
            this.fastAdd(queryHit);
            return true;
        }
        ++this._hitCount;
        return this._children[queryHit.getScore() > this._divider ? 1 : 0].add(queryHit);
    }

    private void split() {
        this._children[0] = new HitStoreNode(this._size);
        this._children[1] = new HitStoreNode(this._size);
        this._divider /= (double)this._hitCount;
        for (int i = 0; i < this._free; ++i) {
            this._children[this._array[i].getScore() > this._divider ? 1 : 0].fastAdd(this._array[i]);
        }
        this._array = null;
    }

    public int getCount() {
        return this._hitCount;
    }

    public double getDivider() {
        return this._divider;
    }

    public HitStoreNode getLChild() {
        return this._children[0];
    }

    public HitStoreNode getRChild() {
        return this._children[1];
    }

    public void setLChild(HitStoreNode hitStoreNode) {
        this._children[0] = hitStoreNode;
    }

    public void setRChild(HitStoreNode hitStoreNode) {
        this._children[1] = hitStoreNode;
    }

    public void decrementCount(int n) {
        this._hitCount -= n;
    }

    public boolean isLeaf() {
        return this._array != null;
    }

    public void sort() {
        this.quicksort(0, this._free - 1);
    }

    public void gatherLeaves(Vector vector) {
        if (this.isLeaf()) {
            vector.addElement(this);
        } else {
            this.getLChild().gatherLeaves(vector);
            this.getRChild().gatherLeaves(vector);
        }
    }

    private int partition(int n, int n2) {
        QueryHit queryHit = this._array[(n + n2) / 2];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (queryHit.betterThan(this._array[--n4])) {
                continue;
            }
            while (this._array[++n3].betterThan(queryHit)) {
            }
            if (n3 >= n4) break;
            QueryHit queryHit2 = this._array[n3];
            this._array[n3] = this._array[n4];
            this._array[n4] = queryHit2;
        }
        return n4;
    }

    private void quicksort(int n, int n2) {
        while (n < n2) {
            int n3 = this.partition(n, n2);
            this.quicksort(n, n3);
            n = n3 + 1;
        }
    }
}

