/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

final class ListViewDropSupport
implements DropTargetListener,
Runnable {
    boolean active = false;
    boolean dropTargetPopupAllowed;
    DropTarget dropTarget;
    int lastIndex = -1;
    protected ListView view;
    protected JList list;
    protected NodeRenderer.List cellRenderer;

    public ListViewDropSupport(ListView listView, JList jList) {
        this(listView, jList, true);
    }

    public ListViewDropSupport(ListView listView, JList jList, boolean bl) {
        this.view = listView;
        this.list = jList;
        this.dropTargetPopupAllowed = bl;
    }

    public void setDropTargetPopupAllowed(boolean bl) {
        this.dropTargetPopupAllowed = bl;
    }

    public boolean isDropTargetPopupAllowed() {
        return this.dropTargetPopupAllowed;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.lastIndex = this.indexWithCheck(dropTargetDragEvent);
        if (this.lastIndex < 0) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            NodeRenderer.dragEnter(this.list.getModel().getElementAt(this.lastIndex));
            this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n = this.indexWithCheck(dropTargetDragEvent);
        if (n < 0) {
            dropTargetDragEvent.rejectDrag();
            if (this.lastIndex >= 0) {
                NodeRenderer.dragExit();
                this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
                this.lastIndex = -1;
            }
        } else {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            if (this.lastIndex != n) {
                if (this.lastIndex < 0) {
                    this.lastIndex = n;
                }
                NodeRenderer.dragExit();
                NodeRenderer.dragEnter(this.list.getModel().getElementAt(n));
                this.list.repaint(this.list.getCellBounds(this.lastIndex, n));
                this.lastIndex = n;
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.lastIndex >= 0) {
            NodeRenderer.dragExit();
            this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        int n = this.list.locationToIndex(dropTargetDropEvent.getLocation());
        Object e = this.list.getModel().getElementAt(n);
        Node node = null;
        if (e instanceof VisualizerNode) {
            node = ((VisualizerNode)e).node;
        }
        int n2 = dropTargetDropEvent.getDropAction();
        if (n < 0 || !this.canDrop(node, n2)) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        PasteType[] pasteTypeArray = DragDropUtilities.getPasteTypes((Node)e, ExplorerDnDManager.getDefault().getDraggedTransferable(2 == n2));
        if (pasteTypeArray == null || pasteTypeArray.length <= 0) {
            dropTargetDropEvent.dropComplete(false);
            RequestProcessor.getDefault().post(this, 500);
            return;
        }
        dropTargetDropEvent.acceptDrop(n2);
        if (n2 != 0x40000000) {
            DragDropUtilities.performDrop(pasteTypeArray[0]);
        }
    }

    private boolean canDrop(Node node, int n) {
        Object object;
        if (node == null) {
            return false;
        }
        if (ExplorerDnDManager.getDefault().getAllowedDragActions() == 0) {
            return false;
        }
        if (2 == n) {
            object = ExplorerDnDManager.getDefault().getDraggedNodes();
            int n2 = 0;
            while (n2 < ((Node[])object).length) {
                if (node.equals(object[n2].getParentNode())) {
                    return false;
                }
                ++n2;
            }
        }
        if ((object = ExplorerDnDManager.getDefault().getDraggedTransferable(2 == n)) == null) {
            return false;
        }
        PasteType[] pasteTypeArray = DragDropUtilities.getPasteTypes(node, (Transferable)object);
        return pasteTypeArray != null && pasteTypeArray.length != 0;
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        this.getDropTarget().setActive(bl);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        DragDropUtilities.dropNotSuccesfull();
    }

    int indexWithCheck(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getDropAction();
        if ((n & this.view.getAllowedDropActions()) == 0) {
            return -1;
        }
        int n2 = this.list.locationToIndex(dropTargetDragEvent.getLocation());
        Object object = this.list.getModel().getElementAt(n2);
        if (object instanceof VisualizerNode) {
            object = ((VisualizerNode)object).node;
        }
        if (n2 < 0) {
            return -1;
        }
        if (!(object instanceof Node)) {
            return -1;
        }
        return n2;
    }

    DropTarget getDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.list, this.view.getAllowedDropActions(), this, false);
        }
        return this.dropTarget;
    }

    NodeRenderer.List getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = (NodeRenderer.List)this.list.getCellRenderer();
        }
        return this.cellRenderer;
    }
}

