/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;
import org.openide.util.actions.CallableSystemAction;

public abstract class ProjectSensitiveAction
extends CallableSystemAction {
    private static final String PROP_LISTENER = "listener";
    static final long serialVersionUID = 1813729754448097488L;

    protected void initialize() {
        super.initialize();
        NodesL nodesL = new NodesL(this.getClass());
        this.putProperty(PROP_LISTENER, nodesL);
    }

    protected void addNotify() {
        super.addNotify();
        NodesL nodesL = (NodesL)this.getProperty(PROP_LISTENER);
        nodesL.setActive(true);
    }

    protected void removeNotify() {
        NodesL nodesL = (NodesL)this.getProperty(PROP_LISTENER);
        nodesL.setActive(false);
        super.removeNotify();
    }

    public boolean isEnabled() {
        NodesL nodesL = (NodesL)this.getProperty(PROP_LISTENER);
        if (!nodesL.isActive()) {
            nodesL.checkEnabled(this);
        }
        return super.isEnabled();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = object = actionEvent == null ? null : actionEvent.getSource();
        if (object instanceof Node) {
            this.performAction((Node)object);
        } else {
            this.performAction(ProjectSensitiveAction.projectDesktop());
        }
    }

    public void performAction() {
        this.performAction(ProjectSensitiveAction.projectDesktop());
    }

    protected abstract void performAction(Node var1);

    protected abstract boolean enable(Node var1);

    static Node projectDesktop() {
        return TopManager.getDefault().getPlaces().nodes().projectDesktop();
    }

    private static final class NodesL
    extends NodeAdapter {
        private Class clazz;
        private NodeListener listener;

        public NodesL(Class clazz) {
            this.clazz = clazz;
        }

        void setActive(boolean bl) {
            if (this.listener == null && bl) {
                this.listener = WeakListener.node(this, TopManager.getDefault());
                TopManager.getDefault().addPropertyChangeListener(this.listener);
                ProjectSensitiveAction.projectDesktop().addNodeListener(this.listener);
                this.checkEnabled(this.action());
                return;
            }
            if (this.listener != null && !bl) {
                TopManager.getDefault().removePropertyChangeListener(this.listener);
                ProjectSensitiveAction.projectDesktop().removeNodeListener(this.listener);
                this.listener = null;
            }
        }

        boolean isActive() {
            return this.listener != null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ProjectSensitiveAction projectSensitiveAction = this.action();
            if ("places".equals(propertyChangeEvent.getPropertyName())) {
                this.setActive(false);
                this.setActive(true);
                return;
            }
            if ("cookie".equals(propertyChangeEvent.getPropertyName())) {
                this.checkEnabled(this.action());
                return;
            }
        }

        private ProjectSensitiveAction action() {
            return (ProjectSensitiveAction)SharedClassObject.findObject(this.clazz);
        }

        void checkEnabled(ProjectSensitiveAction projectSensitiveAction) {
            if (projectSensitiveAction == null) {
                return;
            }
            projectSensitiveAction.setEnabled(projectSensitiveAction.enable(ProjectSensitiveAction.projectDesktop()));
        }
    }
}

