/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.awt.XFocusListener;
import com.sun.star.awt.XKeyListener;
import com.sun.star.awt.XMouseListener;
import com.sun.star.awt.XMouseMotionListener;
import com.sun.star.awt.XPaintListener;
import com.sun.star.awt.XWindowListener;
import com.sun.star.uno.RuntimeException;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JFrame;
import sun.awt.windows.WEmbeddedFrame;

public class WindowAdapter {
    public Frame frame;
    private boolean fullscreen = false;

    public WindowAdapter(int n, boolean bl) {
        if (bl) {
            this.frame = new JFrame("Presentation");
            this.frame.setUndecorated(true);
            this.frame.setVisible(true);
            Graphics2D graphics2D = (Graphics2D)this.frame.getGraphics();
            if (graphics2D.getDeviceConfiguration().getDevice().isFullScreenSupported()) {
                CanvasUtils.printLog("WindowAdapter(Win32): entering fullscreen mode");
                graphics2D.getDeviceConfiguration().getDevice().setFullScreenWindow(this.frame);
                this.fullscreen = true;
            } else {
                CanvasUtils.printLog("WindowAdapter(Win32): fullscreen not supported");
            }
            graphics2D.dispose();
        } else {
            String string = System.getProperty("os.name");
            if (string.startsWith("Windows")) {
                this.frame = new WEmbeddedFrame(n);
            } else {
                throw new RuntimeException();
            }
        }
    }

    public void dispose() {
        if (this.fullscreen) {
            Graphics2D graphics2D = (Graphics2D)this.frame.getGraphics();
            if (graphics2D.getDeviceConfiguration().getDevice().isFullScreenSupported()) {
                CanvasUtils.printLog("WindowAdapter(Win32): leaving fullscreen mode");
                graphics2D.getDeviceConfiguration().getDevice().setFullScreenWindow(null);
            }
            graphics2D.dispose();
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public void setPosSize(int n, int n2, int n3, int n4, short s) {
        this.frame.setBounds(new Rectangle(n, n2, n3, n4));
    }

    public com.sun.star.awt.Rectangle getPosSize() {
        Rectangle rectangle = this.frame.getBounds();
        return new com.sun.star.awt.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public void setEnable(boolean bl) {
        this.frame.setEnabled(bl);
    }

    public void setFocus() {
    }

    public void addWindowListener(XWindowListener xWindowListener) {
    }

    public void removeWindowListener(XWindowListener xWindowListener) {
    }

    public void addFocusListener(XFocusListener xFocusListener) {
    }

    public void removeFocusListener(XFocusListener xFocusListener) {
    }

    public void addKeyListener(XKeyListener xKeyListener) {
    }

    public void removeKeyListener(XKeyListener xKeyListener) {
    }

    public void addMouseListener(XMouseListener xMouseListener) {
    }

    public void removeMouseListener(XMouseListener xMouseListener) {
    }

    public void addMouseMotionListener(XMouseMotionListener xMouseMotionListener) {
    }

    public void removeMouseMotionListener(XMouseMotionListener xMouseMotionListener) {
    }

    public void addPaintListener(XPaintListener xPaintListener) {
    }

    public void removePaintListener(XPaintListener xPaintListener) {
    }
}

