/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.help;

import com.sun.star.help.HelpDatabases;
import com.sun.star.help.HelpIndexer;
import com.sun.star.help.HelpURLStreamHandlerFactory;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class HelpCompiler
implements HelpURLStreamHandlerFactory.Notify {
    private static final String makeRelPrefix = ".." + File.separator;
    private static HelpURLStreamHandlerFactory urlHandler;
    private Hashtable streamTable;
    private String inputFile;
    private String src;
    private String module;
    private String lang;
    private String resEmbStylesheet;
    private static List dependencyList;
    HelpIndexer.ParseStuff stuff = null;

    public static void initURLHandler() {
        try {
            String string = HelpDatabases.getURLMode();
            urlHandler = new HelpURLStreamHandlerFactory(string);
            URL.setURLStreamHandlerFactory(urlHandler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public HelpCompiler(Hashtable hashtable, String string, String string2, String string3, String string4, String string5) {
        this.streamTable = hashtable;
        this.inputFile = string;
        this.src = string2;
        this.resEmbStylesheet = string3;
        this.module = string4;
        this.lang = string5;
        dependencyList = new ArrayList();
        HelpURLStreamHandlerFactory.setMode(null);
        urlHandler.setNotify(this);
    }

    private Object[] switchFind(Node node) {
        Element element;
        HashSet<String> hashSet = new HashSet<String>();
        TreeWalker treeWalker = new TreeWalker(node);
        while ((element = treeWalker.getNextElement("switchinline")) != null) {
            Element element2 = element;
            if (!element2.getAttribute("select").equals("appl")) continue;
            NodeList nodeList = element2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeName().equals("caseinline")) {
                    String string = ((Element)nodeList.item(i)).getAttribute("select");
                    hashSet.add(string);
                    continue;
                }
                if (!nodeList.item(i).getNodeName().equals("defaultinline")) continue;
                hashSet.add("DEFAULT");
            }
        }
        hashSet.add("DEFAULT");
        return hashSet.toArray();
    }

    private Node clone(Node node, String string) {
        Node node2 = node.cloneNode(false);
        NodeList nodeList = node.getChildNodes();
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if ((node3.getNodeName().equals("switchinline") || node3.getNodeName().equals("switch")) && ((Element)node3).getAttribute("select").equals("appl")) {
                int n;
                NodeList nodeList2;
                Node node4;
                int n2;
                NodeList nodeList3 = node3.getChildNodes();
                if (string.equals("DEFAULT")) {
                    for (n2 = 0; n2 < nodeList3.getLength(); ++n2) {
                        node4 = nodeList3.item(n2);
                        if (!node4.getNodeName().equals("defaultinline")) continue;
                        nodeList2 = node4.getChildNodes();
                        for (n = 0; n < nodeList2.getLength(); ++n) {
                            node2.appendChild(this.clone(node4.getChildNodes().item(n), string));
                        }
                        continue block0;
                    }
                    continue;
                }
                for (n2 = 0; n2 < nodeList3.getLength(); ++n2) {
                    node4 = nodeList3.item(n2);
                    if (!node4.getNodeName().equals("caseinline") || !((Element)node4).getAttribute("select").equals(string)) continue;
                    nodeList2 = node4.getChildNodes();
                    for (n = 0; n < nodeList2.getLength(); ++n) {
                        node2.appendChild(this.clone(node4.getChildNodes().item(n), string));
                    }
                    continue block0;
                }
                continue;
            }
            node2.appendChild(this.clone(nodeList.item(i), string));
        }
        return node2;
    }

    public boolean compile() throws UnsupportedEncodingException {
        InputStreamReader inputStreamReader;
        String string;
        String string2;
        File file = new File(this.inputFile);
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = file.getAbsolutePath();
        }
        try {
            string = new File(this.src).getCanonicalPath();
        }
        catch (IOException iOException) {
            string = new File(this.inputFile).getAbsolutePath();
        }
        byte[] byArray = null;
        try {
            byArray = this.getSourceDocument(file.toURL().toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("ERROR: malformed URL '" + this.inputFile + "': " + malformedURLException.getMessage());
            return false;
        }
        if (byArray == null) {
            System.err.println("ERROR: file not existing: " + string);
            System.exit(1);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("ERROR: unsupported Encoding '" + this.inputFile + "': " + unsupportedEncodingException.getMessage());
            return false;
        }
        InputSource inputSource = new InputSource(inputStreamReader);
        inputSource.setEncoding("UTF8");
        XmlDocument xmlDocument = null;
        try {
            xmlDocument = XmlDocument.createXmlDocument((InputSource)inputSource, (boolean)false);
        }
        catch (Exception exception) {
            System.err.println("ERROR: XmlDocument.createXmlDocument() failed for '" + this.inputFile + "': " + exception.getMessage());
            return false;
        }
        Object object = null;
        String string3 = null;
        String string4 = null;
        Object[] objectArray = this.switchFind((Node)xmlDocument);
        for (int i = 0; i < objectArray.length; ++i) {
            Node node;
            String string5 = (String)objectArray[i];
            Element element = (Element)this.clone(xmlDocument.getDocumentElement(), string5);
            TreeWalker treeWalker = new TreeWalker((Node)element);
            HashSet<Object> hashSet = new HashSet<Object>();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            Hashtable hashtable = new Hashtable();
            Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
            while ((node = treeWalker.getNext()) != null) {
                Object object2;
                Object object3;
                Object object4;
                if (string3 == null && node.getNodeName().equals("filename")) {
                    object4 = node.getChildNodes();
                    object3 = object4.item(0);
                    if (object3.getNodeType() != 3) continue;
                    string3 = ((Text)object3).getData();
                    continue;
                }
                if (string4 == null && node.getNodeName().equals("title")) {
                    string4 = this.dump(node);
                    if (string4 != null && string4.length() != 0) continue;
                    string4 = "<notitle>";
                    continue;
                }
                if (node.getNodeName().equals("bookmark")) {
                    object4 = (Element)node;
                    object3 = object4.getAttribute("branch");
                    object2 = null;
                    String string6 = object4.getAttribute("id");
                    if (((String)object3).startsWith("hid")) {
                        int n = ((String)object3).lastIndexOf(47);
                        if (n == -1) continue;
                        object2 = ((String)object3).substring(1 + n);
                        if (object == null) {
                            object = object2;
                        }
                        hashSet2.add(object2);
                        hashSet.add(string6 == null || string6.length() == 0 ? object2 : (String)object2 + "#" + string6);
                        continue;
                    }
                    if (((String)object3).equals("index")) {
                        LinkedList<String> linkedList = new LinkedList<String>();
                        NodeList nodeList = object4.getChildNodes();
                        for (int j = 0; j < nodeList.getLength(); ++j) {
                            boolean bl;
                            Node node2 = nodeList.item(j);
                            if (!node2.getNodeName().equals("bookmark_value")) continue;
                            String string7 = ((Element)node2).getAttribute("embedded");
                            boolean bl2 = bl = string7 != null && "true".equals(string7.toLowerCase());
                            if (bl) continue;
                            String string8 = this.dump(node2);
                            int n = string8.indexOf(59);
                            if (n != -1) {
                                String string9 = string8.substring(0, n).trim();
                                String string10 = string8.substring(1 + n).trim();
                                string8 = string9 + ";" + string10;
                            }
                            linkedList.add(string8);
                        }
                        if (linkedList.isEmpty()) continue;
                        hashtable.put(string6, linkedList);
                        continue;
                    }
                    if (!((String)object3).equals("contents")) continue;
                    continue;
                }
                if (!node.getNodeName().equals("ahelp")) continue;
                object4 = this.dump(node).trim();
                object3 = null;
                object2 = hashSet2.iterator();
                while (object2.hasNext()) {
                    object3 = (String)object2.next();
                    hashtable2.put(object3, object4);
                }
                if (hashSet2.isEmpty()) continue;
                hashSet2 = new HashSet();
            }
            this.addEntryToJarFile(string5, "text", element.toString().getBytes("UTF8"));
            this.addEntryToJarFile(string5, "hidlist", hashSet);
            this.addEntryToJarFile(string5, "helptexts", hashtable2);
            this.addEntryToJarFile(string5, "keywords", hashtable);
        }
        try {
            this.addEntryToJarFile("document", "id", object != null ? ((String)object).getBytes("UTF8") : "".getBytes("UTF8"));
            this.addEntryToJarFile("document", "path", string3 != null ? string3.getBytes("UTF8") : "".getBytes("UTF8"));
            this.addEntryToJarFile("document", "title", string4 != null ? string4.getBytes("UTF8") : "".getBytes("UTF8"));
            String string11 = this.module;
            if (string3 != null && string3.length() != 0 && string3.startsWith("/text/")) {
                string11 = string3.substring("/text/".length());
                string11 = string11.substring(0, string11.indexOf(47));
            }
            this.addEntryToJarFile("document", "module", string11.getBytes("UTF8"));
        }
        catch (IOException iOException) {
            System.err.println("ERROR: IOException in compile(): '" + iOException.getMessage());
            return false;
        }
        return true;
    }

    public void notify(URL uRL) {
        dependencyList.add(uRL);
    }

    private byte[] getSourceDocument(String string) {
        if (this.stuff == null) {
            this.stuff = new HelpIndexer.ParseStuff(this.resEmbStylesheet);
            this.stuff.setParameter("Language", this.lang);
            try {
                this.stuff.setParameter("fsroot", new File(this.src).toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("ERROR: malformed URL '" + this.src + "': " + malformedURLException.getMessage());
                System.exit(1);
            }
        }
        return this.stuff.parse(string);
    }

    private String dump(Node node) {
        String string = new String();
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                string = string + this.dump(nodeList.item(i));
            }
        }
        if (node.getNodeType() == 3) {
            string = string + ((Text)node).getData();
        }
        return string;
    }

    private void addEntryToJarFile(String string, String string2, Object object) {
        if (object == null) {
            return;
        }
        this.streamTable.put((string + "/" + string2).toLowerCase().trim(), object);
    }

    private void addEntryToJarFile(String string, String string2, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.streamTable.put((string + "/" + string2).toLowerCase().trim(), byArray);
    }
}

