/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import org.mozilla.javascript.LabelTable;

class ExceptionTableEntry {
    private int itsStartLabel;
    private int itsEndLabel;
    private int itsHandlerLabel;
    private short itsCatchType;

    ExceptionTableEntry(int n, int n2, int n3, short s) {
        this.itsStartLabel = n;
        this.itsEndLabel = n2;
        this.itsHandlerLabel = n3;
        this.itsCatchType = s;
    }

    short getStartPC(LabelTable labelTable) {
        short s = (short)labelTable.getLabelPC(this.itsStartLabel & Integer.MAX_VALUE);
        if (s == -1) {
            throw new RuntimeException("start label not defined");
        }
        return s;
    }

    short getEndPC(LabelTable labelTable) {
        short s = (short)labelTable.getLabelPC(this.itsEndLabel & Integer.MAX_VALUE);
        if (s == -1) {
            throw new RuntimeException("end label not defined");
        }
        return s;
    }

    short getHandlerPC(LabelTable labelTable) {
        short s = (short)labelTable.getLabelPC(this.itsHandlerLabel & Integer.MAX_VALUE);
        if (s == -1) {
            throw new RuntimeException("handler label not defined");
        }
        return s;
    }

    short getCatchType() {
        return this.itsCatchType;
    }
}

