/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.debug.DebuggableScript;

final class InterpreterData
implements Serializable,
DebuggableScript {
    static final long serialVersionUID = 4815333329084415557L;
    static final int INITIAL_MAX_ICODE_LENGTH = 1024;
    static final int INITIAL_STRINGTABLE_SIZE = 64;
    static final int INITIAL_NUMBERTABLE_SIZE = 64;
    String itsName;
    String itsSource;
    String itsSourceFile;
    boolean itsNeedsActivation;
    boolean itsFromEvalCode;
    boolean itsCheckThis;
    int itsFunctionType;
    String[] itsStringTable;
    double[] itsDoubleTable;
    InterpreterData[] itsNestedFunctions;
    Object[] itsRegExpLiterals;
    byte[] itsICode = new byte[this.itsICodeTop];
    int itsICodeTop = 1024;
    int itsMaxVars;
    int itsMaxLocals;
    int itsMaxTryDepth;
    int itsMaxStack;
    int itsMaxFrameArray;
    String[] argNames;
    int argCount;
    int itsMaxCalleeArgs;
    Object securityDomain;

    InterpreterData(Object object) {
        this.itsStringTable = new String[64];
        this.securityDomain = object;
    }

    public boolean isFunction() {
        return this.itsFunctionType != 0;
    }

    public String getFunctionName() {
        return this.itsName;
    }

    public String getSourceName() {
        return this.itsSourceFile;
    }

    public boolean isGeneratedScript() {
        return ScriptRuntime.isGeneratedScript(this.itsSourceFile);
    }

    public int[] getLineNumbers() {
        return Interpreter.getLineNumbers(this);
    }
}

