/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.LineBuffer;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class TokenStream {
    static final int TSF_NEWLINES = 1;
    static final int TSF_FUNCTION = 2;
    static final int TSF_RETURN_EXPR = 4;
    static final int TSF_RETURN_VOID = 8;
    static final int TSF_REGEXP = 16;
    static final int TSF_DIRTYLINE = 32;
    private static final int EOF_CHAR = -1;
    public static final int ERROR = -1;
    public static final int EOF = 0;
    public static final int EOL = 1;
    public static final int POPV = 2;
    public static final int ENTERWITH = 3;
    public static final int LEAVEWITH = 4;
    public static final int RETURN = 5;
    public static final int GOTO = 6;
    public static final int IFEQ = 7;
    public static final int IFNE = 8;
    public static final int DUP = 9;
    public static final int SETNAME = 10;
    public static final int BITOR = 11;
    public static final int BITXOR = 12;
    public static final int BITAND = 13;
    public static final int EQ = 14;
    public static final int NE = 15;
    public static final int LT = 16;
    public static final int LE = 17;
    public static final int GT = 18;
    public static final int GE = 19;
    public static final int LSH = 20;
    public static final int RSH = 21;
    public static final int URSH = 22;
    public static final int ADD = 23;
    public static final int SUB = 24;
    public static final int MUL = 25;
    public static final int DIV = 26;
    public static final int MOD = 27;
    public static final int BITNOT = 28;
    public static final int NEG = 29;
    public static final int NEW = 30;
    public static final int DELPROP = 31;
    public static final int TYPEOF = 32;
    public static final int NAMEINC = 33;
    public static final int PROPINC = 34;
    public static final int ELEMINC = 35;
    public static final int NAMEDEC = 36;
    public static final int PROPDEC = 37;
    public static final int ELEMDEC = 38;
    public static final int GETPROP = 39;
    public static final int SETPROP = 40;
    public static final int GETELEM = 41;
    public static final int SETELEM = 42;
    public static final int CALL = 43;
    public static final int NAME = 44;
    public static final int NUMBER = 45;
    public static final int STRING = 46;
    public static final int ZERO = 47;
    public static final int ONE = 48;
    public static final int NULL = 49;
    public static final int THIS = 50;
    public static final int FALSE = 51;
    public static final int TRUE = 52;
    public static final int SHEQ = 53;
    public static final int SHNE = 54;
    public static final int CLOSURE = 55;
    public static final int REGEXP = 56;
    public static final int POP = 57;
    public static final int POS = 58;
    public static final int VARINC = 59;
    public static final int VARDEC = 60;
    public static final int BINDNAME = 61;
    public static final int THROW = 62;
    public static final int IN = 63;
    public static final int INSTANCEOF = 64;
    public static final int GOSUB = 65;
    public static final int RETSUB = 66;
    public static final int CALLSPECIAL = 67;
    public static final int GETTHIS = 68;
    public static final int NEWTEMP = 69;
    public static final int USETEMP = 70;
    public static final int GETBASE = 71;
    public static final int GETVAR = 72;
    public static final int SETVAR = 73;
    public static final int UNDEFINED = 74;
    public static final int TRY = 75;
    public static final int ENDTRY = 76;
    public static final int NEWSCOPE = 77;
    public static final int TYPEOFNAME = 78;
    public static final int ENUMINIT = 79;
    public static final int ENUMNEXT = 80;
    public static final int GETPROTO = 81;
    public static final int GETPARENT = 82;
    public static final int SETPROTO = 83;
    public static final int SETPARENT = 84;
    public static final int SCOPE = 85;
    public static final int GETSCOPEPARENT = 86;
    public static final int THISFN = 87;
    public static final int JTHROW = 88;
    public static final int SEMI = 89;
    public static final int LB = 90;
    public static final int RB = 91;
    public static final int LC = 92;
    public static final int RC = 93;
    public static final int LP = 94;
    public static final int RP = 95;
    public static final int COMMA = 96;
    public static final int ASSIGN = 97;
    public static final int HOOK = 98;
    public static final int COLON = 99;
    public static final int OR = 100;
    public static final int AND = 101;
    public static final int EQOP = 102;
    public static final int RELOP = 103;
    public static final int SHOP = 104;
    public static final int UNARYOP = 105;
    public static final int INC = 106;
    public static final int DEC = 107;
    public static final int DOT = 108;
    public static final int PRIMARY = 109;
    public static final int FUNCTION = 110;
    public static final int EXPORT = 111;
    public static final int IMPORT = 112;
    public static final int IF = 113;
    public static final int ELSE = 114;
    public static final int SWITCH = 115;
    public static final int CASE = 116;
    public static final int DEFAULT = 117;
    public static final int WHILE = 118;
    public static final int DO = 119;
    public static final int FOR = 120;
    public static final int BREAK = 121;
    public static final int CONTINUE = 122;
    public static final int VAR = 123;
    public static final int WITH = 124;
    public static final int CATCH = 125;
    public static final int FINALLY = 126;
    public static final int RESERVED = 127;
    public static final int NOP = 128;
    public static final int NOT = 129;
    public static final int PRE = 130;
    public static final int POST = 131;
    public static final int VOID = 132;
    public static final int BLOCK = 133;
    public static final int ARRAYLIT = 134;
    public static final int OBJLIT = 135;
    public static final int LABEL = 136;
    public static final int TARGET = 137;
    public static final int LOOP = 138;
    public static final int ENUMDONE = 139;
    public static final int EXPRSTMT = 140;
    public static final int PARENT = 141;
    public static final int CONVERT = 142;
    public static final int JSR = 143;
    public static final int NEWLOCAL = 144;
    public static final int USELOCAL = 145;
    public static final int SCRIPT = 146;
    public static final int LAST_TOKEN = 146;
    private LineBuffer in;
    int flags;
    String regExpFlags;
    private String sourceName;
    private String line;
    private Scriptable scope;
    private int pushbackToken;
    private int tokenno;
    private int op;
    private String string = "";
    private double number;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;

    public static String tokenToName(int n) {
        return "";
    }

    public String tokenToString(int n) {
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    private int stringToKeyword(String string) {
        int n;
        block86: {
            String string2 = string;
            n = 0;
            String string3 = null;
            block0 : switch (string2.length()) {
                case 2: {
                    char c = string2.charAt(1);
                    if (c == 'f') {
                        if (string2.charAt(0) != 'i') break;
                        n = 113;
                        break block86;
                    } else if (c == 'n') {
                        if (string2.charAt(0) != 'i') break;
                        n = 16231;
                        break block86;
                    } else {
                        if (c != 'o' || string2.charAt(0) != 'd') break;
                        n = 119;
                    }
                    break block86;
                }
                case 3: {
                    switch (string2.charAt(0)) {
                        case 'f': {
                            if (string2.charAt(2) != 'r' || string2.charAt(1) != 'o') break;
                            n = 120;
                            break block86;
                        }
                        case 'i': {
                            if (string2.charAt(2) != 't' || string2.charAt(1) != 'n') break;
                            n = 127;
                            break block86;
                        }
                        case 'n': {
                            if (string2.charAt(2) != 'w' || string2.charAt(1) != 'e') break;
                            n = 30;
                            break block86;
                        }
                        case 't': {
                            if (string2.charAt(2) != 'y' || string2.charAt(1) != 'r') break;
                            n = 75;
                            break block86;
                        }
                        case 'v': {
                            if (string2.charAt(2) != 'r' || string2.charAt(1) != 'a') break;
                            n = 123;
                            break block86;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (string2.charAt(0)) {
                        case 'b': {
                            string3 = "byte";
                            n = 127;
                            break;
                        }
                        case 'c': {
                            char c = string2.charAt(3);
                            if (c == 'e') {
                                if (string2.charAt(2) != 's' || string2.charAt(1) != 'a') break;
                                n = 116;
                                break block86;
                            } else {
                                if (c != 'r' || string2.charAt(2) != 'a' || string2.charAt(1) != 'h') break;
                                n = 127;
                            }
                            break block86;
                        }
                        case 'e': {
                            char c = string2.charAt(3);
                            if (c == 'e') {
                                if (string2.charAt(2) != 's' || string2.charAt(1) != 'l') break;
                                n = 114;
                                break block86;
                            } else {
                                if (c != 'm' || string2.charAt(2) != 'u' || string2.charAt(1) != 'n') break;
                                n = 127;
                            }
                            break block86;
                        }
                        case 'g': {
                            string3 = "goto";
                            n = 127;
                            break;
                        }
                        case 'l': {
                            string3 = "long";
                            n = 127;
                            break;
                        }
                        case 'n': {
                            string3 = "null";
                            n = 12653;
                            break;
                        }
                        case 't': {
                            char c = string2.charAt(3);
                            if (c == 'e') {
                                if (string2.charAt(2) != 'u' || string2.charAt(1) != 'r') break;
                                n = 13421;
                                break block86;
                            } else {
                                if (c != 's' || string2.charAt(2) != 'i' || string2.charAt(1) != 'h') break;
                                n = 12909;
                            }
                            break block86;
                        }
                        case 'v': {
                            string3 = "void";
                            n = 33897;
                            break;
                        }
                        case 'w': {
                            string3 = "with";
                            n = 124;
                            break;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (string2.charAt(2)) {
                        case 'a': {
                            string3 = "class";
                            n = 127;
                            break;
                        }
                        case 'e': {
                            string3 = "break";
                            n = 121;
                            break;
                        }
                        case 'i': {
                            string3 = "while";
                            n = 118;
                            break;
                        }
                        case 'l': {
                            string3 = "false";
                            n = 13165;
                            break;
                        }
                        case 'n': {
                            char c = string2.charAt(0);
                            if (c == 'c') {
                                string3 = "const";
                                n = 127;
                                break;
                            }
                            if (c != 'f') break;
                            string3 = "final";
                            n = 127;
                            break;
                        }
                        case 'o': {
                            char c = string2.charAt(0);
                            if (c == 'f') {
                                string3 = "float";
                                n = 127;
                                break;
                            }
                            if (c != 's') break;
                            string3 = "short";
                            n = 127;
                            break;
                        }
                        case 'p': {
                            string3 = "super";
                            n = 127;
                            break;
                        }
                        case 'r': {
                            string3 = "throw";
                            n = 62;
                            break;
                        }
                        case 't': {
                            string3 = "catch";
                            n = 125;
                            break;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (string2.charAt(1)) {
                        case 'a': {
                            string3 = "native";
                            n = 127;
                            break;
                        }
                        case 'e': {
                            char c = string2.charAt(0);
                            if (c == 'd') {
                                string3 = "delete";
                                n = 31;
                                break;
                            }
                            if (c != 'r') break;
                            string3 = "return";
                            n = 5;
                            break;
                        }
                        case 'h': {
                            string3 = "throws";
                            n = 127;
                            break;
                        }
                        case 'm': {
                            string3 = "import";
                            n = 112;
                            break;
                        }
                        case 'o': {
                            string3 = "double";
                            n = 127;
                            break;
                        }
                        case 't': {
                            string3 = "static";
                            n = 127;
                            break;
                        }
                        case 'u': {
                            string3 = "public";
                            n = 127;
                            break;
                        }
                        case 'w': {
                            string3 = "switch";
                            n = 115;
                            break;
                        }
                        case 'x': {
                            string3 = "export";
                            n = 111;
                            break;
                        }
                        case 'y': {
                            string3 = "typeof";
                            n = 8297;
                            break;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (string2.charAt(1)) {
                        case 'a': {
                            string3 = "package";
                            n = 127;
                            break block0;
                        }
                        case 'e': {
                            string3 = "default";
                            n = 117;
                            break block0;
                        }
                        case 'i': {
                            string3 = "finally";
                            n = 126;
                            break block0;
                        }
                        case 'o': {
                            string3 = "boolean";
                            n = 127;
                            break block0;
                        }
                        case 'r': {
                            string3 = "private";
                            n = 127;
                            break block0;
                        }
                        case 'x': {
                            string3 = "extends";
                            n = 127;
                            break block0;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (string2.charAt(0)) {
                        case 'a': {
                            string3 = "abstract";
                            n = 127;
                            break block0;
                        }
                        case 'c': {
                            string3 = "continue";
                            n = 122;
                            break block0;
                        }
                        case 'd': {
                            string3 = "debugger";
                            n = 127;
                            break block0;
                        }
                        case 'f': {
                            string3 = "function";
                            n = 110;
                            break block0;
                        }
                        case 'v': {
                            string3 = "volatile";
                            n = 127;
                            break block0;
                        }
                    }
                    break;
                }
                case 9: {
                    char c = string2.charAt(0);
                    if (c == 'i') {
                        string3 = "interface";
                        n = 127;
                        break;
                    }
                    if (c == 'p') {
                        string3 = "protected";
                        n = 127;
                        break;
                    }
                    if (c != 't') break;
                    string3 = "transient";
                    n = 127;
                    break;
                }
                case 10: {
                    char c = string2.charAt(1);
                    if (c == 'm') {
                        string3 = "implements";
                        n = 127;
                        break;
                    }
                    if (c != 'n') break;
                    string3 = "instanceof";
                    n = 16487;
                    break;
                }
                case 12: {
                    string3 = "synchronized";
                    n = 127;
                }
            }
            if (string3 != null && string3 != string2 && !string3.equals(string2)) {
                return 0;
            }
        }
        if (n == 0) {
            return 0;
        }
        this.op = n >> 8;
        return n & 0xFF;
    }

    public TokenStream(Reader reader, Scriptable scriptable, String string, int n) {
        this.in = new LineBuffer(reader, n);
        this.scope = scriptable;
        this.pushbackToken = 0;
        this.sourceName = string;
        this.flags = 0;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public boolean matchToken(int n) throws IOException {
        int n2 = this.getToken();
        if (n2 == n) {
            return true;
        }
        --this.tokenno;
        this.pushbackToken = n2;
        return false;
    }

    public void clearPushback() {
        this.pushbackToken = 0;
    }

    public void ungetToken(int n) {
        if (this.pushbackToken != 0 && n != -1) {
            String string = Context.getMessage2("msg.token.replaces.pushback", this.tokenToString(n), this.tokenToString(this.pushbackToken));
            throw new RuntimeException(string);
        }
        this.pushbackToken = n;
        --this.tokenno;
    }

    public int peekToken() throws IOException {
        int n;
        this.pushbackToken = n = this.getToken();
        --this.tokenno;
        return n;
    }

    public int peekTokenSameLine() throws IOException {
        this.flags |= 1;
        int n = this.peekToken();
        this.flags &= 0xFFFFFFFE;
        if (this.pushbackToken == 1) {
            this.pushbackToken = 0;
        }
        return n;
    }

    protected static boolean isJSIdentifier(String string) {
        int n = string.length();
        if (n == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c != '\\' || i + 5 < n || string.charAt(i + 1) != 'u' || 0 > TokenStream.xDigitToInt(string.charAt(i + 2)) || 0 > TokenStream.xDigitToInt(string.charAt(i + 3)) || 0 > TokenStream.xDigitToInt(string.charAt(i + 4)) || 0 > TokenStream.xDigitToInt(string.charAt(i + 5))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAlpha(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90;
    }

    static boolean isDigit(int n) {
        return n >= 48 && n <= 57;
    }

    static int xDigitToInt(int n) {
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        if (97 <= n && n <= 102) {
            return n - 87;
        }
        if (65 <= n && n <= 70) {
            return n - 55;
        }
        return -1;
    }

    public static boolean isJSSpace(int n) {
        return n == 32 || n == 9 || n == 12 || n == 11 || n == 160 || Character.getType((char)n) == 12;
    }

    public static boolean isJSLineTerminator(int n) {
        return n == 10 || n == 13 || n == 8232 || n == 8233;
    }

    private void skipLine() throws IOException {
        int n;
        while ((n = this.in.read()) != -1 && n != 10) {
        }
        this.in.unread();
    }

    public int getToken() throws IOException {
        boolean bl;
        int n;
        ++this.tokenno;
        if (this.pushbackToken != 0) {
            int n2 = this.pushbackToken;
            this.pushbackToken = 0;
            return n2;
        }
        do {
            if ((n = this.in.read()) != 10) continue;
            this.flags &= 0xFFFFFFDF;
            if ((this.flags & 1) != 0) break;
        } while (TokenStream.isJSSpace(n) || n == 10);
        if (n == -1) {
            return 0;
        }
        if (n != 45 && n != 10) {
            this.flags |= 0x20;
        }
        boolean bl2 = false;
        if (n == 92) {
            n = this.in.read();
            if (n == 117) {
                bl = true;
                bl2 = true;
                this.stringBufferTop = 0;
            } else {
                bl = false;
                n = 92;
                this.in.unread();
            }
        } else {
            bl = Character.isJavaIdentifierStart((char)n);
            if (bl) {
                this.stringBufferTop = 0;
                this.addToString(n);
            }
        }
        if (bl) {
            int n3;
            boolean bl3 = bl2;
            while (true) {
                if (bl2) {
                    int n4 = 0;
                    for (n3 = 0; n3 != 4 && (n4 = n4 << 4 | TokenStream.xDigitToInt(n = this.in.read())) >= 0; ++n3) {
                    }
                    if (n4 < 0) {
                        this.reportSyntaxError("msg.invalid.escape", null);
                        return -1;
                    }
                    this.addToString(n4);
                    bl2 = false;
                    continue;
                }
                n = this.in.read();
                if (n == 92) {
                    n = this.in.read();
                    if (n == 117) {
                        bl2 = true;
                        bl3 = true;
                        continue;
                    }
                    this.reportSyntaxError("msg.illegal.character", null);
                    return -1;
                }
                if (!Character.isJavaIdentifierPart((char)n)) break;
                this.addToString(n);
            }
            this.in.unread();
            String string = this.getStringFromBuffer();
            if (!bl3 && (n3 = this.stringToKeyword(string)) != 0) {
                if (n3 != 127) {
                    return n3;
                }
                if (!Context.getContext().hasFeature(3)) {
                    return n3;
                }
                Object[] objectArray = new Object[]{string};
                this.reportSyntaxWarning("msg.reserved.keyword", objectArray);
            }
            this.string = string;
            return 44;
        }
        if (TokenStream.isDigit(n) || n == 46 && TokenStream.isDigit(this.in.peek())) {
            double d;
            this.stringBufferTop = 0;
            int n5 = 10;
            if (n == 48) {
                n = this.in.read();
                if (n == 120 || n == 88) {
                    n5 = 16;
                    n = this.in.read();
                } else if (TokenStream.isDigit(n)) {
                    n5 = 8;
                } else {
                    this.addToString(48);
                }
            }
            if (n5 == 16) {
                while (0 <= TokenStream.xDigitToInt(n)) {
                    this.addToString(n);
                    n = this.in.read();
                }
            } else {
                while (48 <= n && n <= 57) {
                    if (n5 == 8 && n >= 56) {
                        Object[] objectArray = new Object[]{n == 56 ? "8" : "9"};
                        this.reportSyntaxWarning("msg.bad.octal.literal", objectArray);
                        n5 = 10;
                    }
                    this.addToString(n);
                    n = this.in.read();
                }
            }
            boolean bl4 = true;
            if (n5 == 10 && (n == 46 || n == 101 || n == 69)) {
                bl4 = false;
                if (n == 46) {
                    do {
                        this.addToString(n);
                    } while (TokenStream.isDigit(n = this.in.read()));
                }
                if (n == 101 || n == 69) {
                    this.addToString(n);
                    n = this.in.read();
                    if (n == 43 || n == 45) {
                        this.addToString(n);
                        n = this.in.read();
                    }
                    if (!TokenStream.isDigit(n)) {
                        this.reportSyntaxError("msg.missing.exponent", null);
                        return -1;
                    }
                    do {
                        this.addToString(n);
                    } while (TokenStream.isDigit(n = this.in.read()));
                }
            }
            this.in.unread();
            String string = this.getStringFromBuffer();
            if (n5 == 10 && !bl4) {
                try {
                    d = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    Object[] objectArray = new Object[]{numberFormatException.getMessage()};
                    this.reportSyntaxError("msg.caught.nfe", objectArray);
                    return -1;
                }
            } else {
                d = ScriptRuntime.stringToNumber(string, 0, n5);
            }
            this.number = d;
            return 45;
        }
        if (n == 34 || n == 39) {
            int n6 = n;
            int n7 = 0;
            this.stringBufferTop = 0;
            n = this.in.read();
            block46: while (n != n6) {
                if (n == 10 || n == -1) {
                    this.in.unread();
                    this.reportSyntaxError("msg.unterminated.string.lit", null);
                    return -1;
                }
                if (n == 92) {
                    n = this.in.read();
                    switch (n) {
                        case 98: {
                            n = 8;
                            break;
                        }
                        case 102: {
                            n = 12;
                            break;
                        }
                        case 110: {
                            n = 10;
                            break;
                        }
                        case 114: {
                            n = 13;
                            break;
                        }
                        case 116: {
                            n = 9;
                            break;
                        }
                        case 118: {
                            n = 11;
                            break;
                        }
                        case 117: {
                            int n8 = this.stringBufferTop;
                            this.addToString(117);
                            int n9 = 0;
                            for (int i = 0; i != 4; ++i) {
                                n = this.in.read();
                                if ((n9 = n9 << 4 | TokenStream.xDigitToInt(n)) < 0) continue block46;
                                this.addToString(n);
                            }
                            this.stringBufferTop = n8;
                            n = n9;
                            break;
                        }
                        case 120: {
                            n = this.in.read();
                            int n8 = TokenStream.xDigitToInt(n);
                            if (n8 < 0) {
                                this.addToString(120);
                                continue block46;
                            }
                            int n9 = n;
                            n = this.in.read();
                            if ((n8 = n8 << 4 | TokenStream.xDigitToInt(n)) < 0) {
                                this.addToString(120);
                                this.addToString(n9);
                                continue block46;
                            }
                            n = n8;
                            break;
                        }
                        default: {
                            if (48 > n || n >= 56) break;
                            n7 = n - 48;
                            n = this.in.read();
                            if (48 <= n && n < 56) {
                                n7 = 8 * n7 + n - 48;
                                n = this.in.read();
                                if (48 <= n && n < 56 && n7 <= 31) {
                                    n7 = 8 * n7 + n - 48;
                                    n = this.in.read();
                                }
                            }
                            this.in.unread();
                            n = n7;
                        }
                    }
                }
                this.addToString(n);
                n = this.in.read();
            }
            this.string = this.getStringFromBuffer();
            return 46;
        }
        switch (n) {
            case 10: {
                return 1;
            }
            case 59: {
                return 89;
            }
            case 91: {
                return 90;
            }
            case 93: {
                return 91;
            }
            case 123: {
                return 92;
            }
            case 125: {
                return 93;
            }
            case 40: {
                return 94;
            }
            case 41: {
                return 95;
            }
            case 44: {
                return 96;
            }
            case 63: {
                return 98;
            }
            case 58: {
                return 99;
            }
            case 46: {
                return 108;
            }
            case 124: {
                if (this.in.match(124)) {
                    return 100;
                }
                if (this.in.match(61)) {
                    this.op = 11;
                    return 97;
                }
                return 11;
            }
            case 94: {
                if (this.in.match(61)) {
                    this.op = 12;
                    return 97;
                }
                return 12;
            }
            case 38: {
                if (this.in.match(38)) {
                    return 101;
                }
                if (this.in.match(61)) {
                    this.op = 13;
                    return 97;
                }
                return 13;
            }
            case 61: {
                if (this.in.match(61)) {
                    this.op = this.in.match(61) ? 53 : 14;
                    return 102;
                }
                this.op = 128;
                return 97;
            }
            case 33: {
                if (this.in.match(61)) {
                    this.op = this.in.match(61) ? 54 : 15;
                    return 102;
                }
                this.op = 129;
                return 105;
            }
            case 60: {
                if (this.in.match(33)) {
                    if (this.in.match(45)) {
                        if (this.in.match(45)) {
                            this.skipLine();
                            return this.getToken();
                        }
                        this.in.unread();
                    }
                    this.in.unread();
                }
                if (this.in.match(60)) {
                    if (this.in.match(61)) {
                        this.op = 20;
                        return 97;
                    }
                    this.op = 20;
                    return 104;
                }
                if (this.in.match(61)) {
                    this.op = 17;
                    return 103;
                }
                this.op = 16;
                return 103;
            }
            case 62: {
                if (this.in.match(62)) {
                    if (this.in.match(62)) {
                        if (this.in.match(61)) {
                            this.op = 22;
                            return 97;
                        }
                        this.op = 22;
                        return 104;
                    }
                    if (this.in.match(61)) {
                        this.op = 21;
                        return 97;
                    }
                    this.op = 21;
                    return 104;
                }
                if (this.in.match(61)) {
                    this.op = 19;
                    return 103;
                }
                this.op = 18;
                return 103;
            }
            case 42: {
                if (this.in.match(61)) {
                    this.op = 25;
                    return 97;
                }
                return 25;
            }
            case 47: {
                if (this.in.match(47)) {
                    this.skipLine();
                    return this.getToken();
                }
                if (this.in.match(42)) {
                    while (!((n = this.in.read()) == -1 || n == 42 && this.in.match(47))) {
                    }
                    if (n == -1) {
                        this.reportSyntaxError("msg.unterminated.comment", null);
                        return -1;
                    }
                    return this.getToken();
                }
                if ((this.flags & 0x10) != 0) {
                    this.stringBufferTop = 0;
                    while ((n = this.in.read()) != 47) {
                        if (n == 10 || n == -1) {
                            this.in.unread();
                            this.reportSyntaxError("msg.unterminated.re.lit", null);
                            return -1;
                        }
                        if (n == 92) {
                            this.addToString(n);
                            n = this.in.read();
                        }
                        this.addToString(n);
                    }
                    int n10 = this.stringBufferTop;
                    while (true) {
                        if (this.in.match(103)) {
                            this.addToString(103);
                            continue;
                        }
                        if (this.in.match(105)) {
                            this.addToString(105);
                            continue;
                        }
                        if (!this.in.match(109)) break;
                        this.addToString(109);
                    }
                    if (TokenStream.isAlpha(this.in.peek())) {
                        this.reportSyntaxError("msg.invalid.re.flag", null);
                        return -1;
                    }
                    this.string = new String(this.stringBuffer, 0, n10);
                    this.regExpFlags = new String(this.stringBuffer, n10, this.stringBufferTop - n10);
                    return 56;
                }
                if (this.in.match(61)) {
                    this.op = 26;
                    return 97;
                }
                return 26;
            }
            case 37: {
                this.op = 27;
                if (this.in.match(61)) {
                    return 97;
                }
                return 27;
            }
            case 126: {
                this.op = 28;
                return 105;
            }
            case 43: {
                if (this.in.match(61)) {
                    this.op = 23;
                    return 97;
                }
                if (this.in.match(43)) {
                    return 106;
                }
                return 23;
            }
            case 45: {
                if (this.in.match(61)) {
                    this.op = 24;
                    n = 97;
                } else if (this.in.match(45)) {
                    if (0 == (this.flags & 0x20) && this.in.match(62)) {
                        this.skipLine();
                        return this.getToken();
                    }
                    n = 107;
                } else {
                    n = 24;
                }
                this.flags |= 0x20;
                return n;
            }
        }
        this.reportSyntaxError("msg.illegal.character", null);
        return -1;
    }

    private String getStringFromBuffer() {
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int n) {
        if (this.stringBufferTop == this.stringBuffer.length) {
            char[] cArray = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, cArray, 0, this.stringBufferTop);
            this.stringBuffer = cArray;
        }
        this.stringBuffer[this.stringBufferTop++] = (char)n;
    }

    public void reportSyntaxError(String string, Object[] objectArray) {
        String string2 = Context.getMessage(string, objectArray);
        if (this.scope != null) {
            throw NativeGlobal.constructError(Context.getContext(), "SyntaxError", string2, this.scope, this.getSourceName(), this.getLineno(), this.getOffset(), this.getLine());
        }
        Context.reportError(string2, this.getSourceName(), this.getLineno(), this.getLine(), this.getOffset());
    }

    private void reportSyntaxWarning(String string, Object[] objectArray) {
        String string2 = Context.getMessage(string, objectArray);
        Context.reportWarning(string2, this.getSourceName(), this.getLineno(), this.getLine(), this.getOffset());
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getLineno() {
        return this.in.getLineno();
    }

    public int getOp() {
        return this.op;
    }

    public String getString() {
        return this.string;
    }

    public double getNumber() {
        return this.number;
    }

    public String getLine() {
        return this.in.getLine();
    }

    public int getOffset() {
        return this.in.getOffset();
    }

    public int getTokenno() {
        return this.tokenno;
    }

    public boolean eof() {
        return this.in.eof();
    }
}

