/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Wrapper;

public class WrappedException
extends EvaluatorException
implements Wrapper {
    private Throwable exception;

    public WrappedException(Throwable throwable) {
        super(throwable.getMessage());
        this.exception = throwable.fillInStackTrace();
    }

    public String getMessage() {
        return "WrappedException of " + this.exception.toString();
    }

    public String getLocalizedMessage() {
        return "WrappedException of " + this.exception.getLocalizedMessage();
    }

    public Throwable getWrappedException() {
        return this.exception;
    }

    public Object unwrap() {
        return this.exception;
    }

    public static EvaluatorException wrapException(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof EvaluatorException) {
            return (EvaluatorException)throwable;
        }
        return new WrappedException(throwable);
    }
}

