/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility;

import com.sun.star.accessibility.XAccessible;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import org.openoffice.java.accessibility.AccessibleObjectFactory;

public class PopupWindow
extends Window {
    AccessibleContext accessibleContext = null;
    ContainerProxy layeredPane = new ContainerProxy(AccessibleRole.LAYERED_PANE);
    ContainerProxy rootPane = new ContainerProxy(AccessibleRole.ROOT_PANE);
    ContainerProxy popupLayer = new ContainerProxy(AccessibleRole.PANEL);
    boolean opened = false;
    boolean visible = false;

    public PopupWindow(Window window) {
        super(window);
        super.add(this.rootPane);
        this.rootPane.add(this.layeredPane);
        AccessibleContext accessibleContext = this.rootPane.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleParent(this);
        }
    }

    static PopupWindow create(XAccessible xAccessible) {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window != null) {
            PopupWindow popupWindow = new PopupWindow(window);
            popupWindow.setVisible(true);
            AccessibleObjectFactory.invokeAndWait();
            AccessibleObjectFactory.addChild((Container)popupWindow, xAccessible);
            return popupWindow;
        }
        return null;
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container container = this.getParent();
            return container == null || container.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            if (bl && !this.opened) {
                AccessibleObjectFactory.postWindowOpened(this);
                this.opened = true;
            }
        }
    }

    public Component add(Component component) {
        AccessibleContext accessibleContext;
        this.popupLayer.add(component);
        this.layeredPane.add(this.popupLayer);
        if (component instanceof Accessible && (accessibleContext = this.layeredPane.getAccessibleContext()) != null) {
            accessibleContext.firePropertyChange("AccessibleChild", null, this.popupLayer.getAccessibleContext());
        }
        return component;
    }

    public void remove(Component component) {
        AccessibleContext accessibleContext;
        this.layeredPane.remove(this.popupLayer);
        if (component instanceof Accessible && (accessibleContext = this.layeredPane.getAccessibleContext()) != null) {
            accessibleContext.firePropertyChange("AccessibleChild", this.popupLayer.getAccessibleContext(), null);
        }
        this.popupLayer.remove(component);
    }

    public void dispose() {
        this.setVisible(false);
        AccessibleObjectFactory.postWindowClosed(this);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePopupWindow();
        }
        return this.accessibleContext;
    }

    protected class ContainerProxy
    extends Container
    implements Accessible {
        AccessibleContext accessibleContext = null;
        AccessibleRole role;

        protected ContainerProxy(AccessibleRole accessibleRole) {
            this.role = accessibleRole;
        }

        public Component add(Component component) {
            Accessible accessible;
            AccessibleContext accessibleContext;
            if (component instanceof Accessible && (accessibleContext = (accessible = (Accessible)((Object)component)).getAccessibleContext()) != null) {
                accessibleContext.setAccessibleParent(this);
            }
            return super.add(component);
        }

        public void remove(Component component) {
            Accessible accessible;
            AccessibleContext accessibleContext;
            if (component instanceof Accessible && (accessibleContext = (accessible = (Accessible)((Object)component)).getAccessibleContext()) != null) {
                accessibleContext.setAccessibleParent(null);
            }
            super.remove(component);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleContainerProxy();
            }
            return this.accessibleContext;
        }

        private class AccessibleContainerProxy
        extends Container.AccessibleAWTContainer {
            AccessibleContainerProxy() {
                super(ContainerProxy.this);
            }

            public AccessibleRole getAccessibleRole() {
                return ContainerProxy.this.role;
            }
        }
    }

    protected class AccessiblePopupWindow
    extends Window.AccessibleAWTWindow {
        AccessiblePopupWindow() {
            super(PopupWindow.this);
        }
    }
}

