/*
 * Decompiled with CFR 0.152.
 */
package ifc.awt;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XListBox;
import com.sun.star.lang.EventObject;
import lib.MultiMethodTest;
import lib.Status;

public class _XListBox
extends MultiMethodTest {
    public XListBox oObj = null;
    TestActionListener actionListener = new TestActionListener();
    TestItemListener itemListener = new TestItemListener();
    short lineCount = 0;
    short itemCount = 0;

    public void before() {
        this.itemCount = this.oObj.getItemCount();
    }

    public void _addItemListener() {
        this.oObj.addItemListener(this.itemListener);
        this.tRes.tested("addItemListener()", Status.skipped(true));
    }

    public void _removeItemListener() {
        this.requiredMethod("addItemListener()");
        this.oObj.removeItemListener(this.itemListener);
        this.tRes.tested("removeItemListener()", Status.skipped(true));
    }

    public void _addActionListener() {
        this.oObj.addActionListener(this.actionListener);
        this.tRes.tested("addActionListener()", Status.skipped(true));
    }

    public void _removeActionListener() {
        this.requiredMethod("addActionListener()");
        this.oObj.removeActionListener(this.actionListener);
        this.tRes.tested("removeActionListener()", Status.skipped(true));
    }

    public void _addItem() {
        this.requiredMethod("getItemCount()");
        boolean bl = true;
        this.oObj.addItem("Item1", this.itemCount);
        bl = this.oObj.getItemCount() == this.itemCount + 1;
        this.tRes.tested("addItem()", bl);
    }

    public void _addItems() {
        this.executeMethod("addItem()");
        boolean bl = true;
        short s = this.oObj.getItemCount();
        this.oObj.addItems(new String[]{"Item2", "Item3"}, s);
        bl = this.oObj.getItemCount() == s + 2;
        this.tRes.tested("addItems()", bl);
    }

    public void _removeItems() {
        this.executeMethod("getItems()");
        this.executeMethod("getItem()");
        this.executeMethod("getSelectedItemPos()");
        this.executeMethod("getSelectedItemsPos()");
        this.executeMethod("getSelectedItem()");
        this.executeMethod("getSelectedItems()");
        boolean bl = true;
        short s = this.oObj.getItemCount();
        this.oObj.removeItems((short)0, s);
        bl = this.oObj.getItemCount() == 0;
        this.tRes.tested("removeItems()", bl);
    }

    public void _getItemCount() {
        this.itemCount = this.oObj.getItemCount();
        this.tRes.tested("getItemCount()", this.itemCount >= 0);
    }

    public void _getItem() {
        this.requiredMethod("addItems()");
        boolean bl = true;
        String string = this.oObj.getItem(this.itemCount);
        bl = "Item1".equals(string);
        this.tRes.tested("getItem()", bl);
    }

    public void _getItems() {
        this.requiredMethod("addItems()");
        boolean bl = true;
        String[] stringArray = this.oObj.getItems();
        for (int i = this.itemCount; i < this.itemCount + 3; ++i) {
            bl &= ("Item" + (i + 1 - this.itemCount)).equals(stringArray[i]);
        }
        this.tRes.tested("getItems()", bl);
    }

    public void _getDropDownLineCount() {
        boolean bl = true;
        this.lineCount = this.oObj.getDropDownLineCount();
        this.tRes.tested("getDropDownLineCount()", bl);
    }

    public void _setDropDownLineCount() {
        this.requiredMethod("getDropDownLineCount()");
        boolean bl = true;
        this.oObj.setDropDownLineCount((short)(this.lineCount + 1));
        bl = this.oObj.getDropDownLineCount() == this.lineCount + 1;
        this.tRes.tested("setDropDownLineCount()", bl);
    }

    public void _getSelectedItemPos() {
        this.requiredMethod("addItems()");
        boolean bl = true;
        this.oObj.selectItemPos((short)1, true);
        short s = this.oObj.getSelectedItemPos();
        bl = s == 1;
        this.tRes.tested("getSelectedItemPos()", bl);
    }

    public void _getSelectedItemsPos() {
        this.requiredMethod("selectItemsPos()");
        boolean bl = true;
        short s = this.oObj.getItemCount();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            this.oObj.selectItemPos(s2, false);
        }
        this.oObj.selectItemsPos(new short[]{0, 2}, true);
        short[] sArray = this.oObj.getSelectedItemsPos();
        bl = sArray != null && sArray.length == 2 && sArray[0] == 0 && sArray[1] == 2;
        this.tRes.tested("getSelectedItemsPos()", bl);
    }

    public void _getSelectedItem() {
        this.requiredMethod("addItems()");
        boolean bl = true;
        short s = this.oObj.getItemCount();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            this.oObj.selectItemPos(s2, false);
        }
        this.oObj.selectItem("Item3", true);
        String string = this.oObj.getSelectedItem();
        bl = "Item3".equals(string);
        this.tRes.tested("getSelectedItem()", bl);
    }

    public void _getSelectedItems() {
        this.requiredMethod("selectItemsPos()");
        this.requiredMethod("getItem()");
        boolean bl = true;
        short s = this.oObj.getItemCount();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            this.oObj.selectItemPos(s2, false);
        }
        this.oObj.selectItemsPos(new short[]{0, 2}, true);
        String[] stringArray = this.oObj.getSelectedItems();
        bl = stringArray != null && stringArray.length == 2 && this.oObj.getItem((short)0).equals(stringArray[0]) && this.oObj.getItem((short)2).equals(stringArray[1]);
        this.tRes.tested("getSelectedItems()", bl);
    }

    public void _selectItemPos() {
        this.requiredMethod("addItems()");
        boolean bl = true;
        short s = this.oObj.getItemCount();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            this.oObj.selectItemPos(s2, false);
        }
        this.oObj.selectItemPos((short)1, true);
        this.tRes.tested("selectItemPos()", bl);
    }

    public void _selectItemsPos() {
        this.requiredMethod("addItems()");
        this.requiredMethod("setMultipleMode()");
        boolean bl = true;
        this.oObj.selectItemsPos(new short[]{0, 2}, true);
        this.tRes.tested("selectItemsPos()", bl);
    }

    public void _selectItem() {
        this.requiredMethod("addItems()");
        boolean bl = true;
        this.oObj.selectItem("Item3", true);
        this.tRes.tested("selectItem()", bl);
    }

    public void _isMutipleMode() {
        this.requiredMethod("setMultipleMode()");
        boolean bl = true;
        bl = this.oObj.isMutipleMode();
        this.tRes.tested("isMutipleMode()", bl);
    }

    public void _setMultipleMode() {
        boolean bl = true;
        this.oObj.setMultipleMode(true);
        this.tRes.tested("setMultipleMode()", bl);
    }

    public void _makeVisible() {
        this.requiredMethod("addItems()");
        boolean bl = true;
        this.oObj.makeVisible((short)2);
        this.tRes.tested("makeVisible()", bl);
    }

    protected class TestItemListener
    implements XItemListener {
        public boolean disposingCalled = false;
        public boolean itemStateChangedCalled = false;

        protected TestItemListener() {
        }

        public void disposing(EventObject eventObject) {
            this.disposingCalled = true;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.itemStateChangedCalled = true;
        }
    }

    protected class TestActionListener
    implements XActionListener {
        public boolean disposingCalled = false;
        public boolean actionPerformedCalled = false;

        protected TestActionListener() {
        }

        public void disposing(EventObject eventObject) {
            this.disposingCalled = true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.actionPerformedCalled = true;
        }
    }
}

