/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XFastPropertySet;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import lib.MultiMethodTest;
import lib.StatusException;
import util.ValueChanger;

public class _XFastPropertySet
extends MultiMethodTest {
    public XFastPropertySet oObj = null;
    private Vector handles = new Vector();
    private int handle = -1;
    private Set exclude = null;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;

    protected void before() {
        this.exclude = (Set)this.tEnv.getObjRelation("XFastPropertySet.ExcludeProps");
        if (this.exclude == null) {
            this.exclude = new HashSet();
        }
    }

    public void _setFastPropertyValue() {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = _XFastPropertySet.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, (Object)this.oObj);
        XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
        if (xPropertySetInfo == null) {
            this.log.println("getPropertySetInfo() method returned null");
            this.tRes.tested("setFastPropertyValue()", false);
        }
        this.getPropsToTest(xPropertySetInfo);
        Object object = null;
        Object object2 = null;
        if (this.handle == -1) {
            this.log.println("*** No changeable properties found ***");
            this.tRes.tested("setFastPropertyValue()", false);
        } else {
            try {
                object = this.oObj.getFastPropertyValue(this.handle);
                object2 = ValueChanger.changePValue(object);
                this.oObj.setFastPropertyValue(this.handle, object2);
                object2 = this.oObj.getFastPropertyValue(this.handle);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                this.log.println("Exception occured while trying to change property with handle = " + this.handle);
                unknownPropertyException.printStackTrace(this.log);
            }
            catch (WrappedTargetException wrappedTargetException) {
                this.log.println("Exception occured while trying to change property with handle = " + this.handle);
                wrappedTargetException.printStackTrace(this.log);
            }
            catch (PropertyVetoException propertyVetoException) {
                this.log.println("Exception occured while trying to change property with handle = " + this.handle);
                propertyVetoException.printStackTrace(this.log);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("Exception occured while trying to change property with handle = " + this.handle);
                illegalArgumentException.printStackTrace(this.log);
            }
            this.tRes.tested("setFastPropertyValue()", !object.equals(object2));
        }
    }

    public void _getFastPropertyValue() {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = _XFastPropertySet.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, (Object)this.oObj);
        XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
        if (xPropertySetInfo == null) {
            this.log.println("getPropertySetInfo() method returned null");
            this.tRes.tested("getFastPropertyValue()", false);
        }
        this.getPropsToTest(xPropertySetInfo);
        try {
            this.oObj.getFastPropertyValue(this.handle);
            this.tRes.tested("getFastPropertyValue()", true);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            this.log.println("Exception occured while trying to get property '" + this.handle + "'");
            unknownPropertyException.printStackTrace(this.log);
            this.tRes.tested("getFastPropertyValue()", false);
        }
        catch (WrappedTargetException wrappedTargetException) {
            this.log.println("Exception occured while trying to get property '" + this.handle + "'");
            wrappedTargetException.printStackTrace(this.log);
            this.tRes.tested("getFastPropertyValue()", false);
        }
    }

    private void getPropsToTest(XPropertySetInfo xPropertySetInfo) {
        Property[] propertyArray = xPropertySetInfo.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (this.exclude.contains(propertyArray[i].Name)) continue;
            Property property = propertyArray[i];
            String string = property.Name;
            int n = property.Handle;
            this.log.println("Checking '" + string + "' with handle = " + n);
            boolean bl = (property.Attributes & 0x10) == 0;
            boolean bl2 = (property.Attributes & 1) == 0;
            boolean bl3 = false;
            if (bl && bl2) {
                bl3 = this.isChangeable(n);
            }
            if (!bl || !bl2 || !bl3) continue;
            this.handles.add(new Integer(n));
        }
        Random random = new Random();
        int n = random.nextInt(this.handles.size());
        this.handle = (Integer)this.handles.elementAt(n);
    }

    private boolean isChangeable(int n) {
        boolean bl = false;
        try {
            Object object = this.oObj.getFastPropertyValue(n);
            Object object2 = null;
            if (object != null) {
                object2 = ValueChanger.changePValue(object);
            } else {
                this.log.println("Property with handle = " + n + " is null but 'MAYBEVOID' isn't set");
            }
            if (object2 != null) {
                this.oObj.setFastPropertyValue(n, object2);
                bl = !object.equals(this.oObj.getFastPropertyValue(n));
            } else {
                this.log.println("Couldn't change Property with handle " + n);
            }
        }
        catch (WrappedTargetException wrappedTargetException) {
            this.log.println("Property with handle " + n + " throws exception");
            wrappedTargetException.printStackTrace(this.log);
            throw new StatusException("Property with handle " + n + " throws exception", wrappedTargetException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Property with handle " + n + " throws exception");
            illegalArgumentException.printStackTrace(this.log);
            throw new StatusException("Property with handle " + n + " throws exception", illegalArgumentException);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.log.println("Property with handle " + n + " throws exception");
            propertyVetoException.printStackTrace(this.log);
            throw new StatusException("Property with handle " + n + " throws exception", propertyVetoException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            this.log.println("Property with handle " + n + " throws exception");
            unknownPropertyException.printStackTrace(this.log);
            throw new StatusException("Property with handle " + n + " throws exception", unknownPropertyException);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

