/*
 * Decompiled with CFR 0.152.
 */
package ifc.util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.table.TableSortField;
import com.sun.star.table.TableSortFieldType;
import com.sun.star.util.XSortable;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XSortable
extends MultiMethodTest {
    public XSortable oObj = null;
    XSortChecker checker = null;
    PropertyValue[] oPV = null;

    protected void before() {
        this.checker = (XSortChecker)this.tEnv.getObjRelation("SORTCHECKER");
        if (this.checker == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'SORTCHECKER'"));
        }
        this.checker.setPrintWriter(this.log);
    }

    public void _createSortDescriptor() {
        boolean bl = false;
        this.log.println("test for createSortDescriptor() ");
        this.oPV = this.oObj.createSortDescriptor();
        if (this.oPV.length > 0) {
            bl = true;
            for (int i = 0; i < this.oPV.length; ++i) {
                this.log.println("DescriptorProperty " + i + ": Name=" + this.oPV[i].Name + "; Value=" + this.oPV[i].Value);
                if (!this.oPV[i].Name.equals("SortFields")) continue;
                TableSortField[] tableSortFieldArray = (TableSortField[])this.oPV[i].Value;
                for (int j = 0; j < tableSortFieldArray.length; ++j) {
                    this.log.println("\t isAscending:  " + tableSortFieldArray[j].IsAscending);
                    this.log.println("\t IsCaseSensitive:  " + tableSortFieldArray[j].IsCaseSensitive);
                    this.log.println("\t CollatorAlgorithm:  " + tableSortFieldArray[j].CollatorAlgorithm);
                }
            }
        }
        this.log.println("Found " + this.oPV.length + " PropertyValues");
        this.tRes.tested("createSortDescriptor()", bl);
    }

    public void _sort() {
        this.checker.prepareToSort();
        this.log.println("############## Sort algorithm: Alphanumeric Order: Ascending");
        this.modifyDescriptor(false, true);
        this.oObj.sort(this.oPV);
        boolean bl = this.checker.checkSort(false, true);
        this.log.println("############################################################");
        this.log.println("############# Sort algorithm: Alphanumeric Order: Descending");
        this.modifyDescriptor(false, false);
        this.oObj.sort(this.oPV);
        bl = this.checker.checkSort(false, false);
        this.log.println("############################################################");
        this.log.println("################# Sort algorithm: Numeric Order: Ascending");
        this.modifyDescriptor(true, true);
        this.oObj.sort(this.oPV);
        bl = this.checker.checkSort(true, true);
        this.log.println("############################################################");
        this.log.println("################## Sort algorithm: Numeric Order: Descending");
        this.modifyDescriptor(true, false);
        this.oObj.sort(this.oPV);
        bl = this.checker.checkSort(true, false);
        this.log.println("############################################################");
        this.tRes.tested("sort()", bl);
    }

    protected void modifyDescriptor(boolean bl, boolean bl2) {
        int n;
        TableSortField[] tableSortFieldArray;
        int n2;
        for (n2 = 0; n2 < this.oPV.length; ++n2) {
            if (this.oPV[n2].Name.equals("SortFields")) {
                tableSortFieldArray = (TableSortField[])this.oPV[n2].Value;
                if (tableSortFieldArray.length == 0) {
                    tableSortFieldArray = new TableSortField[]{new TableSortField()};
                }
                for (n = 0; n < tableSortFieldArray.length; ++n) {
                    tableSortFieldArray[n].IsAscending = bl2;
                    if (bl) {
                        tableSortFieldArray[n].FieldType = TableSortFieldType.NUMERIC;
                        tableSortFieldArray[n].CollatorAlgorithm = "numeric";
                        continue;
                    }
                    tableSortFieldArray[n].FieldType = TableSortFieldType.ALPHANUMERIC;
                    tableSortFieldArray[n].CollatorAlgorithm = "alphanumeric";
                }
                this.oPV[n2].Value = tableSortFieldArray;
            }
            if (this.oPV[n2].Name.equals("isSortInTable")) {
                this.oPV[n2].Value = new Boolean(true);
            }
            if (!this.oPV[n2].Name.equals("IsSortColumns")) continue;
            this.oPV[n2].Value = new Boolean(false);
        }
        this.log.println("Modified sort descriptor: ");
        if (this.oPV.length > 0) {
            for (n2 = 0; n2 < this.oPV.length; ++n2) {
                this.log.println("DescriptorProperty " + n2 + ": Name=" + this.oPV[n2].Name + "; Value=" + this.oPV[n2].Value);
                if (!this.oPV[n2].Name.equals("SortFields")) continue;
                tableSortFieldArray = (TableSortField[])this.oPV[n2].Value;
                for (n = 0; n < tableSortFieldArray.length; ++n) {
                    this.log.println("\t isAscending:  " + tableSortFieldArray[n].IsAscending);
                    this.log.println("\t IsCaseSensitive:  " + tableSortFieldArray[n].IsCaseSensitive);
                    this.log.println("\t CollatorAlgorithm:  " + tableSortFieldArray[n].CollatorAlgorithm);
                }
            }
        }
    }

    protected void after() {
        this.disposeEnvironment();
    }

    public static interface XSortChecker {
        public void prepareToSort();

        public boolean checkSort(boolean var1, boolean var2);

        public void setPrintWriter(PrintWriter var1);
    }
}

