/*
 * Decompiled with CFR 0.152.
 */
package mod._jdbc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;

public class JDBCDriver
extends TestCase {
    protected synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        try {
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.comp.sdbc.JDBCDriver");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException(Status.failed("Couldn't create object"));
        }
        printWriter.println("creating a new environment for JDBCDriver object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        String string = (String)testParameters.get("jdbc.url");
        if (string == null) {
            throw new StatusException(Status.failed("Couldn't get 'jdbc.url' from ini-file"));
        }
        testEnvironment.addObjRelation("XDriver.URL", "jdbc:" + string);
        String string2 = (String)testParameters.get("jdbc.user");
        String string3 = (String)testParameters.get("jdbc.password");
        if (string2 == null || string3 == null) {
            throw new StatusException(Status.failed("Couldn't get 'jdbc.user' or 'jdbc.password' from ini-file"));
        }
        PropertyValue[] propertyValueArray = new PropertyValue[4];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "JavaDriverClass";
        propertyValueArray[0].Value = "org.gjt.mm.mysql.Driver";
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "user";
        propertyValueArray[1].Value = string2;
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "password";
        propertyValueArray[2].Value = string3;
        propertyValueArray[3] = new PropertyValue();
        propertyValueArray[3].Name = "isPasswordRequired";
        propertyValueArray[3].Value = new Boolean(true);
        testEnvironment.addObjRelation("XDriver.INFO", propertyValueArray);
        String string4 = (String)testParameters.get("flat.url");
        if (string4 == null) {
            throw new StatusException(Status.failed("Couldn't get 'flat.url' from ini-file"));
        }
        testEnvironment.addObjRelation("XDriver.UNSUITABLE_URL", "sdbc:flat:" + string4);
        return testEnvironment;
    }
}

