/*
 * Decompiled with CFR 0.152.
 */
package mod._shlibloader.uno;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class DLLComponentLoader
extends TestCase {
    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
    }

    protected TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        Object object = null;
        XMultiServiceFactory xMultiServiceFactory = null;
        try {
            xMultiServiceFactory = (XMultiServiceFactory)testParameters.getMSF();
            object = xMultiServiceFactory.createInstance("com.sun.star.comp.stoc.DLLComponentLoader");
        }
        catch (Exception exception) {
            printWriter.println("DLLComponentLoader Service not available");
        }
        xInterface = (XInterface)object;
        printWriter.println("    creating a new environment for DLLComponentLoader object");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("ImplementationLoader", "com.sun.star.loader.SharedLibrary");
        String string = (String)testParameters.get("OS");
        if (string == null || string == "") {
            throw new StatusException("Couldn't determine operating system for naming convention.", new NullPointerException());
        }
        String string2 = "javaloader.uno";
        string2 = !string.equals("wntmsci") ? string2 + ".so" : string2 + ".dll";
        String string3 = utils.getOfficeURL(xMultiServiceFactory) + "/" + string2;
        testEnvironment.addObjRelation("ImplementationUrl", string3);
        printWriter.println("looking for shared lib: " + string3);
        testEnvironment.addObjRelation("ImplementationName", "com.sun.star.comp.stoc.JavaComponentLoader");
        return testEnvironment;
    }
}

