/*
 * Decompiled with CFR 0.152.
 */
package mod._sw;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.ParagraphDsc;
import util.SOfficeFactory;
import util.TableDsc;

public class SwXBodyText
extends TestCase {
    XTextDocument xTextDoc = null;
    SOfficeFactory SOF = null;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        this.SOF = SOfficeFactory.getFactory((XMultiServiceFactory)testParameters.getMSF());
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = this.SOF.createTextDoc(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    public synchronized TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) throws StatusException {
        XText xText = null;
        printWriter.println("creating a test environment");
        printWriter.println("    getting the bodytext of textdocument with getText()");
        xText = this.xTextDoc.getText();
        printWriter.println("    creating a new environment for bodytext object");
        TestEnvironment testEnvironment = new TestEnvironment(xText);
        printWriter.println(" adding Text as ObjRelation");
        testEnvironment.addObjRelation("TEXT", xText);
        printWriter.println("    adding InstDescriptor object");
        TableDsc tableDsc = new TableDsc(6, 4);
        printWriter.println("    adding InstCreator object");
        testEnvironment.addObjRelation("XTEXTINFO", new InstCreator(this.xTextDoc, tableDsc));
        printWriter.println("    adding Paragraph");
        ParagraphDsc paragraphDsc = new ParagraphDsc();
        testEnvironment.addObjRelation("PARA", new InstCreator(this.xTextDoc, paragraphDsc));
        return testEnvironment;
    }
}

