/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.drawing.XControlShape;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.WriterTools;
import util.utils;

public class TabControllerModel
extends TestCase {
    XTextDocument xTextDoc;

    protected void initialize(TestParameters testParameters, PrintWriter printWriter) {
        try {
            printWriter.println("creating a textdocument");
            this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)testParameters.getMSF());
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create document", exception);
        }
    }

    protected void cleanup(TestParameters testParameters, PrintWriter printWriter) {
        printWriter.println("disposing xTextDoc");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    public TestEnvironment createTestEnvironment(TestParameters testParameters, PrintWriter printWriter) {
        XInterface xInterface = null;
        printWriter.println("inserting some ControlShapes");
        XControlShape xControlShape = FormTools.createControlShape(this.xTextDoc, 3000, 4500, 15000, 1000, "CommandButton");
        XControlShape xControlShape2 = FormTools.createControlShape(this.xTextDoc, 5000, 3500, 7500, 5000, "TextField");
        try {
            xInterface = (XInterface)((XMultiServiceFactory)testParameters.getMSF()).createInstance("com.sun.star.awt.TabControllerModel");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            throw new StatusException("Couldn't create TabControllerModel", exception);
        }
        printWriter.println("creating a new environment for TabControllerModel");
        TestEnvironment testEnvironment = new TestEnvironment(xInterface);
        testEnvironment.addObjRelation("OBJNAME", "stardiv.vcl.controlmodel.TabController");
        testEnvironment.addObjRelation("Model1", xControlShape.getControl());
        testEnvironment.addObjRelation("Model2", xControlShape2.getControl());
        testEnvironment.addObjRelation("noPS", new Boolean(true));
        System.out.println("ImplementationName: " + utils.getImplName(xInterface));
        return testEnvironment;
    }
}

