/*
 * Decompiled with CFR 0.152.
 */
package ifc.form;

import com.sun.star.form.XLoadListener;
import com.sun.star.form.XLoadable;
import com.sun.star.lang.EventObject;
import java.io.PrintWriter;
import lib.MultiMethodTest;

public class _XLoadable
extends MultiMethodTest {
    public XLoadable oObj = null;
    TestLoadListener loadListener = null;

    public void before() {
        this.loadListener = new TestLoadListener(this.log);
    }

    private void shortWait() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void _load() {
        this.requiredMethod("isLoaded()");
        this.requiredMethod("addLoadListener()");
        boolean bl = true;
        this.oObj.load();
        this.shortWait();
        bl = this.oObj.isLoaded() && this.loadListener.loadedCalled;
        this.tRes.tested("load()", bl);
    }

    public void _unload() {
        this.requiredMethod("reload()");
        this.requiredMethod("addLoadListener()");
        boolean bl = true;
        this.oObj.unload();
        this.shortWait();
        bl = !this.oObj.isLoaded() && this.loadListener.unloadedCalled;
        this.tRes.tested("unload()", bl);
    }

    public void _reload() {
        this.requiredMethod("load()");
        this.requiredMethod("addLoadListener()");
        boolean bl = true;
        this.oObj.reload();
        this.shortWait();
        bl = this.oObj.isLoaded() && this.loadListener.reloadedCalled;
        this.tRes.tested("reload()", bl);
    }

    public void _isLoaded() {
        boolean bl = this.oObj.isLoaded();
        if (bl) {
            this.oObj.unload();
        }
        this.tRes.tested("isLoaded()", !(bl = this.oObj.isLoaded()));
    }

    public void _addLoadListener() {
        boolean bl = true;
        this.oObj.addLoadListener(this.loadListener);
        this.tRes.tested("addLoadListener()", bl);
    }

    public void _removeLoadListener() {
        this.requiredMethod("unload()");
        boolean bl = true;
        this.oObj.removeLoadListener(this.loadListener);
        this.loadListener.loadedCalled = false;
        this.oObj.load();
        bl = !this.loadListener.loadedCalled;
        this.tRes.tested("removeLoadListener()", bl);
    }

    protected void after() {
        this.disposeEnvironment();
    }

    protected class TestLoadListener
    implements XLoadListener {
        public boolean disposingCalled = false;
        public boolean loadedCalled = false;
        public boolean reloadedCalled = false;
        public boolean reloadingCalled = false;
        public boolean unloadedCalled = false;
        public boolean unloadingCalled = false;
        private PrintWriter log = null;

        public TestLoadListener(PrintWriter printWriter) {
            this.log = printWriter;
        }

        public void disposing(EventObject eventObject) {
            this.disposingCalled = true;
            this.log.println(" disposing was called.");
        }

        public void loaded(EventObject eventObject) {
            this.loadedCalled = true;
            this.log.println(" loaded was called.");
        }

        public void reloaded(EventObject eventObject) {
            this.reloadedCalled = true;
            this.log.println(" reloaded was called.");
        }

        public void reloading(EventObject eventObject) {
            this.reloadingCalled = true;
            this.log.println(" reloading was called.");
        }

        public void unloaded(EventObject eventObject) {
            this.unloadedCalled = true;
            this.log.println(" unloaded was called.");
        }

        public void unloading(EventObject eventObject) {
            this.unloadingCalled = true;
            this.log.println(" unloading was called.");
        }
    }
}

