/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XModifiable;
import java.util.Vector;

public class DesktopTools {
    static /* synthetic */ Class class$com$sun$star$frame$XDesktop;
    static /* synthetic */ Class class$com$sun$star$frame$XComponentLoader;
    static /* synthetic */ Class class$com$sun$star$lang$XComponent;
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;
    static /* synthetic */ Class class$com$sun$star$util$XModifiable;
    static /* synthetic */ Class class$com$sun$star$util$XCloseable;

    public static XComponentLoader getCLoader(XMultiServiceFactory xMultiServiceFactory) {
        XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(class$com$sun$star$frame$XDesktop == null ? (class$com$sun$star$frame$XDesktop = DesktopTools.class$("com.sun.star.frame.XDesktop")) : class$com$sun$star$frame$XDesktop, DesktopTools.createDesktop(xMultiServiceFactory));
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(class$com$sun$star$frame$XComponentLoader == null ? (class$com$sun$star$frame$XComponentLoader = DesktopTools.class$("com.sun.star.frame.XComponentLoader")) : class$com$sun$star$frame$XComponentLoader, (Object)xDesktop);
        return xComponentLoader;
    }

    public static Object createDesktop(XMultiServiceFactory xMultiServiceFactory) {
        Object object;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.frame.Desktop");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Desktop Service not available");
        }
        return object;
    }

    public static XEnumeration getAllComponents(XMultiServiceFactory xMultiServiceFactory) {
        XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(class$com$sun$star$frame$XDesktop == null ? (class$com$sun$star$frame$XDesktop = DesktopTools.class$("com.sun.star.frame.XDesktop")) : class$com$sun$star$frame$XDesktop, DesktopTools.createDesktop(xMultiServiceFactory));
        return xDesktop.getComponents().createEnumeration();
    }

    public static Object[] getAllOpenDocuments(XMultiServiceFactory xMultiServiceFactory) {
        Vector<XComponent> vector = new Vector<XComponent>();
        XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(class$com$sun$star$frame$XDesktop == null ? (class$com$sun$star$frame$XDesktop = DesktopTools.class$("com.sun.star.frame.XDesktop")) : class$com$sun$star$frame$XDesktop, DesktopTools.createDesktop(xMultiServiceFactory));
        XEnumeration xEnumeration = DesktopTools.getAllComponents(xMultiServiceFactory);
        while (xEnumeration.hasMoreElements()) {
            try {
                XComponent xComponent = (XComponent)UnoRuntime.queryInterface(class$com$sun$star$lang$XComponent == null ? DesktopTools.class$("com.sun.star.lang.XComponent") : class$com$sun$star$lang$XComponent, xEnumeration.nextElement());
                if (DesktopTools.getDocumentType(xComponent) == null) continue;
                vector.add(xComponent);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (WrappedTargetException wrappedTargetException) {}
        }
        return vector.toArray();
    }

    public static String getDocumentType(XComponent xComponent) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = DesktopTools.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo, (Object)xComponent);
        if (xServiceInfo == null) {
            return "";
        }
        if (xServiceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            return "scalc";
        }
        if (xServiceInfo.supportsService("com.sun.star.text.TextDocument")) {
            return "swriter";
        }
        if (xServiceInfo.supportsService("com.sun.star.drawing.DrawingDocument")) {
            return "sdraw";
        }
        if (xServiceInfo.supportsService("com.sun.star.formula.FormulaProperties")) {
            return "smath";
        }
        return null;
    }

    public static XComponent openNewDoc(XMultiServiceFactory xMultiServiceFactory, String string, PropertyValue[] propertyValueArray) {
        XComponent xComponent = null;
        try {
            xComponent = DesktopTools.getCLoader(xMultiServiceFactory).loadComponentFromURL("private:factory/" + string, "_blank", 0, propertyValueArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Document could not be opened");
        }
        return xComponent;
    }

    public static XComponent loadDoc(XMultiServiceFactory xMultiServiceFactory, String string, PropertyValue[] propertyValueArray) {
        XComponent xComponent = null;
        try {
            xComponent = DesktopTools.getCLoader(xMultiServiceFactory).loadComponentFromURL(string, "_blank", 0, propertyValueArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Document could not be loaded");
        }
        return xComponent;
    }

    public static void closeDoc(XInterface xInterface) {
        String string = System.getProperty("KeepDocument");
        if (string != null) {
            System.out.println("The property 'KeepDocument' is set and so the document won't be disposed");
            return;
        }
        XModifiable xModifiable = (XModifiable)UnoRuntime.queryInterface(class$com$sun$star$util$XModifiable == null ? (class$com$sun$star$util$XModifiable = DesktopTools.class$("com.sun.star.util.XModifiable")) : class$com$sun$star$util$XModifiable, (Object)xInterface);
        XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(class$com$sun$star$util$XCloseable == null ? (class$com$sun$star$util$XCloseable = DesktopTools.class$("com.sun.star.util.XCloseable")) : class$com$sun$star$util$XCloseable, (Object)xInterface);
        try {
            xModifiable.setModified(false);
            xCloseable.close(true);
        }
        catch (CloseVetoException closeVetoException) {
            System.out.println("Couldn't close document");
        }
        catch (DisposedException disposedException) {
            System.out.println("Couldn't close document");
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Couldn't close document");
        }
        catch (PropertyVetoException propertyVetoException) {
            System.out.println("Couldn't close document");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

