/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import java.util.Vector;
import util.AccessibilityTools;
import util.utils;

public class UITools {
    private static final AccessibilityTools mAT = new AccessibilityTools();
    private final XAccessible mXRoot;
    private final XMultiServiceFactory mMSF;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleText;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleEditableText;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleValue;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleAction;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessible;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleSelection;
    static /* synthetic */ Class class$com$sun$star$uno$XInterface;
    static /* synthetic */ Class class$com$sun$star$awt$XExtendedToolkit;
    static /* synthetic */ Class class$com$sun$star$awt$XWindow;

    public UITools(XMultiServiceFactory xMultiServiceFactory, XModel xModel) {
        this.mMSF = xMultiServiceFactory;
        this.mXRoot = UITools.makeRoot(this.mMSF, xModel);
    }

    public UITools(XMultiServiceFactory xMultiServiceFactory, XWindow xWindow) {
        this.mMSF = xMultiServiceFactory;
        this.mXRoot = UITools.makeRoot(xWindow);
    }

    private static XAccessible makeRoot(XMultiServiceFactory xMultiServiceFactory, XModel xModel) {
        XWindow xWindow = AccessibilityTools.getCurrentWindow(xMultiServiceFactory, xModel);
        return AccessibilityTools.getAccessibleObject(xWindow);
    }

    private static String getString(XInterface xInterface) {
        XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleText == null ? (class$com$sun$star$accessibility$XAccessibleText = UITools.class$("com.sun.star.accessibility.XAccessibleText")) : class$com$sun$star$accessibility$XAccessibleText, (Object)xInterface);
        return xAccessibleText.getText();
    }

    private static void setString(XInterface xInterface, String string) {
        XAccessibleEditableText xAccessibleEditableText = (XAccessibleEditableText)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleEditableText == null ? (class$com$sun$star$accessibility$XAccessibleEditableText = UITools.class$("com.sun.star.accessibility.XAccessibleEditableText")) : class$com$sun$star$accessibility$XAccessibleEditableText, (Object)xInterface);
        xAccessibleEditableText.setText(string);
    }

    private static Object getValue(XInterface xInterface) {
        XAccessibleValue xAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleValue == null ? (class$com$sun$star$accessibility$XAccessibleValue = UITools.class$("com.sun.star.accessibility.XAccessibleValue")) : class$com$sun$star$accessibility$XAccessibleValue, (Object)xInterface);
        return xAccessibleValue.getCurrentValue();
    }

    private static XAccessible makeRoot(XWindow xWindow) {
        return AccessibilityTools.getAccessibleObject(xWindow);
    }

    public XAccessible getRoot() {
        return this.mXRoot;
    }

    public void setTextEditFiledText(String string, String string2) throws Exception {
        XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)60, string);
        UITools.setString(xAccessibleContext, string2);
    }

    public XAccessibleContext getButton(String string) throws Exception {
        return AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)44, string);
    }

    public void clickButton(String string) throws Exception {
        XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)44, string);
        if (xAccessibleContext == null) {
            throw new Exception("Could not get button '" + string + "'");
        }
        XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleAction == null ? (class$com$sun$star$accessibility$XAccessibleAction = UITools.class$("com.sun.star.accessibility.XAccessibleAction")) : class$com$sun$star$accessibility$XAccessibleAction, (Object)xAccessibleContext);
        try {
            xAccessibleAction.doAccessibleAction(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new Exception("Could not do accessible action with '" + string + "'" + indexOutOfBoundsException.toString());
        }
    }

    private boolean clickToggleButton(String string, boolean bl) {
        XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)62, string);
        if (xAccessibleContext != null) {
            boolean bl2 = xAccessibleContext.getAccessibleStateSet().contains((short)4);
            if (bl2 && !bl || !bl2 && bl) {
                XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleAction == null ? (class$com$sun$star$accessibility$XAccessibleAction = UITools.class$("com.sun.star.accessibility.XAccessibleAction")) : class$com$sun$star$accessibility$XAccessibleAction, (Object)xAccessibleContext);
                try {
                    xAccessibleAction.doAccessibleAction(0);
                    return true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.out.println("Could not do accessible action with '" + string + "'" + indexOutOfBoundsException.toString());
                    return false;
                }
            }
            return true;
        }
        System.out.println("Could not get button '" + string + "'");
        return false;
    }

    public boolean deactivateToggleButton(String string) {
        return this.clickToggleButton(string, false);
    }

    public boolean activateToggleButton(String string) {
        return this.clickToggleButton(string, true);
    }

    public Integer getRadioButtonValue(String string) throws Exception {
        try {
            XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)46, string);
            return (Integer)UITools.getValue(xAccessibleContext);
        }
        catch (Exception exception) {
            throw new Exception("Could not get value from RadioButton '" + string + "' : " + exception.toString());
        }
    }

    public XInterface getGraphic(String string) throws Exception {
        return AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)23, string);
    }

    public void setRadioButtonValue(String string, int n) throws Exception {
        try {
            XAccessibleValue xAccessibleValue;
            XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)46, string);
            if (xAccessibleContext == null) {
                System.out.println("AccessibleObjectForRole couldn't be found for " + string);
            }
            if ((xAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleValue == null ? (class$com$sun$star$accessibility$XAccessibleValue = UITools.class$("com.sun.star.accessibility.XAccessibleValue")) : class$com$sun$star$accessibility$XAccessibleValue, (Object)xAccessibleContext)) == null) {
                System.out.println("XAccessibleValue couldn't be queried for " + string);
            }
            xAccessibleValue.setCurrentValue(new Integer(n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("Could not set value to RadioButton '" + string + "' : " + exception.toString());
        }
    }

    public void selectListboxItem(String string, int n) throws Exception {
        try {
            XAccessibleContext xAccessibleContext = null;
            xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)7, string);
            if (xAccessibleContext == null) {
                xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)40, string);
            }
            XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessible == null ? (class$com$sun$star$accessibility$XAccessible = UITools.class$("com.sun.star.accessibility.XAccessible")) : class$com$sun$star$accessibility$XAccessible, (Object)xAccessibleContext);
            XAccessibleContext xAccessibleContext2 = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)32);
            XAccessibleSelection xAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleSelection == null ? (class$com$sun$star$accessibility$XAccessibleSelection = UITools.class$("com.sun.star.accessibility.XAccessibleSelection")) : class$com$sun$star$accessibility$XAccessibleSelection, (Object)xAccessibleContext2);
            xAccessibleSelection.selectAccessibleChild(n);
        }
        catch (Exception exception) {
            throw new Exception("Could not select item '" + n + "' in listbox '" + string + "' : " + exception.toString());
        }
    }

    public Object[] getListBoxObjects(String string) throws Exception {
        Object[] objectArray;
        Vector<XInterface> vector = new Vector<XInterface>();
        try {
            objectArray = null;
            XAccessibleContext xAccessibleContext = null;
            objectArray = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)7, string);
            if (objectArray == null) {
                objectArray = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)40, string);
            }
            if (objectArray == null) {
                xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)65, string);
            } else {
                XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessible == null ? (class$com$sun$star$accessibility$XAccessible = UITools.class$("com.sun.star.accessibility.XAccessible")) : class$com$sun$star$accessibility$XAccessible, (Object)objectArray);
                xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)32);
            }
            for (int i = 0; i < xAccessibleContext.getAccessibleChildCount(); ++i) {
                try {
                    XAccessible xAccessible = xAccessibleContext.getAccessibleChild(i);
                    XAccessibleContext xAccessibleContext2 = xAccessible.getAccessibleContext();
                    XInterface xInterface = (XInterface)UnoRuntime.queryInterface(class$com$sun$star$uno$XInterface == null ? UITools.class$("com.sun.star.uno.XInterface") : class$com$sun$star$uno$XInterface, (Object)xAccessibleContext2);
                    vector.add(xInterface);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new Exception("Could not get child form list of '" + string + "' : " + indexOutOfBoundsException.toString());
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("Could not get list of items from '" + string + "' : " + exception.toString());
        }
        objectArray = new XInterface[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.get(i);
        }
        return objectArray;
    }

    public String[] getListBoxItems(String string) throws Exception {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        try {
            stringArray = null;
            XAccessibleContext xAccessibleContext = null;
            stringArray = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)7, string);
            if (stringArray == null) {
                stringArray = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)40, string);
            }
            if (stringArray == null) {
                xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)65, string);
            } else {
                XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessible == null ? (class$com$sun$star$accessibility$XAccessible = UITools.class$("com.sun.star.accessibility.XAccessible")) : class$com$sun$star$accessibility$XAccessible, (Object)stringArray);
                xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)32);
            }
            for (int i = 0; i < xAccessibleContext.getAccessibleChildCount(); ++i) {
                try {
                    XAccessible xAccessible = xAccessibleContext.getAccessibleChild(i);
                    XAccessibleContext xAccessibleContext2 = xAccessible.getAccessibleContext();
                    XInterface xInterface = (XInterface)UnoRuntime.queryInterface(class$com$sun$star$uno$XInterface == null ? UITools.class$("com.sun.star.uno.XInterface") : class$com$sun$star$uno$XInterface, (Object)xAccessibleContext2);
                    vector.add(UITools.getString(xInterface));
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new Exception("Could not get child form list of '" + string + "' : " + indexOutOfBoundsException.toString());
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("Could not get list of items from '" + string + "' : " + exception.toString());
        }
        stringArray = new String[vector.size()];
        return vector.toArray(stringArray);
    }

    public void setNumericFieldValue(String string, String string2) throws Exception {
        try {
            XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)60, string);
            XAccessibleEditableText xAccessibleEditableText = (XAccessibleEditableText)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleEditableText == null ? (class$com$sun$star$accessibility$XAccessibleEditableText = UITools.class$("com.sun.star.accessibility.XAccessibleEditableText")) : class$com$sun$star$accessibility$XAccessibleEditableText, (Object)xAccessibleContext);
            UITools.setString(xAccessibleContext, string2);
        }
        catch (Exception exception) {
            throw new Exception("Could not set value '" + string2 + "' into NumericField '" + string + "' : " + exception.toString());
        }
    }

    public String getNumericFieldValue(String string) throws Exception {
        try {
            XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)60, string);
            return UITools.getString(xAccessibleContext);
        }
        catch (Exception exception) {
            throw new Exception("Could get value from NumericField '" + string + "' : " + exception.toString());
        }
    }

    private String removeCharactersFromCurrencyString(String string) throws Exception {
        try {
            int n;
            int n2;
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            for (n2 = 0; n2 < string.length(); ++n2) {
                n = Character.getNumericValue(string.charAt(n2));
                if (n == -1) continue;
                n3 = n2;
                break;
            }
            for (n2 = string.length() - 1; n2 > 0; --n2) {
                n = Character.getNumericValue(string.charAt(n2));
                if (n == -1) continue;
                n4 = n2 + 1;
                break;
            }
            String string2 = string.substring(n3, n4);
            string2 = string2.substring(0, string2.length() - 3) + "#" + string2.substring(string2.length() - 2);
            string2 = utils.replaceAll13(string2, ",", "");
            string2 = utils.replaceAll13(string2, "\\.", "");
            string2 = utils.replaceAll13(string2, "#", ".");
            return string2;
        }
        catch (Exception exception) {
            throw new Exception("Could get remove characters from currency string '" + string + "' : " + exception.toString());
        }
    }

    public Double getNumericFieldNumericValue(String string) throws Exception {
        try {
            Double d = null;
            String string2 = this.getNumericFieldValue(string);
            String string3 = this.removeCharactersFromCurrencyString(string2);
            d = Double.valueOf(string3);
            return d;
        }
        catch (Exception exception) {
            throw new Exception("Could get numeric value from NumericField '" + string + "' : " + exception.toString());
        }
    }

    public String getTextBoxText(String string) throws Exception {
        String string2 = null;
        try {
            XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)51, string);
            XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessible == null ? (class$com$sun$star$accessibility$XAccessible = UITools.class$("com.sun.star.accessibility.XAccessible")) : class$com$sun$star$accessibility$XAccessible, (Object)xAccessibleContext);
            XAccessibleContext xAccessibleContext2 = AccessibilityTools.getAccessibleObjectForRole(xAccessible, (short)61);
            for (int i = 0; i < xAccessibleContext2.getAccessibleChildCount(); ++i) {
                try {
                    XAccessible xAccessible2 = xAccessibleContext2.getAccessibleChild(i);
                    XAccessibleContext xAccessibleContext3 = xAccessible2.getAccessibleContext();
                    XInterface xInterface = (XInterface)UnoRuntime.queryInterface(class$com$sun$star$uno$XInterface == null ? UITools.class$("com.sun.star.uno.XInterface") : class$com$sun$star$uno$XInterface, (Object)xAccessibleContext3);
                    string2 = string2 + UITools.getString(xInterface);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new Exception("Could not get child fom TextFrame of '" + string + "' : " + indexOutOfBoundsException.toString());
                }
            }
            return string2;
        }
        catch (Exception exception) {
            throw new Exception("Could not get content fom Textbox '" + string + "' : " + exception.toString());
        }
    }

    public void setCheckBoxValue(String string, Integer n) throws Exception {
        try {
            XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)4, string);
            XAccessibleValue xAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleValue == null ? (class$com$sun$star$accessibility$XAccessibleValue = UITools.class$("com.sun.star.accessibility.XAccessibleValue")) : class$com$sun$star$accessibility$XAccessibleValue, (Object)xAccessibleContext);
            xAccessibleValue.setCurrentValue(n);
        }
        catch (Exception exception) {
            throw new Exception("Could not set value to CheckBox '" + string + "' : " + exception.toString());
        }
    }

    public Integer getCheckBoxValue(String string) throws Exception {
        try {
            XAccessibleContext xAccessibleContext = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)4, string);
            XAccessibleValue xAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface(class$com$sun$star$accessibility$XAccessibleValue == null ? (class$com$sun$star$accessibility$XAccessibleValue = UITools.class$("com.sun.star.accessibility.XAccessibleValue")) : class$com$sun$star$accessibility$XAccessibleValue, (Object)xAccessibleContext);
            return (Integer)xAccessibleValue.getCurrentValue();
        }
        catch (Exception exception) {
            throw new Exception("Could not set value to CheckBox '" + string + "' : " + exception.toString());
        }
    }

    public XWindow getActiveTopWindow() throws Exception {
        XInterface xInterface = null;
        try {
            xInterface = (XInterface)this.mMSF.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new Exception("Could not toolkit: " + exception.toString());
        }
        XExtendedToolkit xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(class$com$sun$star$awt$XExtendedToolkit == null ? (class$com$sun$star$awt$XExtendedToolkit = UITools.class$("com.sun.star.awt.XExtendedToolkit")) : class$com$sun$star$awt$XExtendedToolkit, (Object)xInterface);
        XTopWindow xTopWindow = xExtendedToolkit.getActiveTopWindow();
        return (XWindow)UnoRuntime.queryInterface(class$com$sun$star$awt$XWindow == null ? (class$com$sun$star$awt$XWindow = UITools.class$("com.sun.star.awt.XWindow")) : class$com$sun$star$awt$XWindow, (Object)xTopWindow);
    }

    public void printAccessibleTree(PrintWriter printWriter) {
        AccessibilityTools.printAccessibleTree(printWriter, this.mXRoot);
    }

    public void printAccessibleTree(PrintWriter printWriter, boolean bl) {
        AccessibilityTools.printAccessibleTree(printWriter, this.mXRoot, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

