/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import java.io.IOException;

public abstract class TupleBinding
implements DataBinding {
    protected TupleFormat format;

    public TupleBinding(TupleFormat format) {
        this.format = format;
    }

    public Object dataToObject(DataBuffer data) throws IOException {
        return this.dataToObject(this.format.dataToInput(data));
    }

    public void objectToData(Object object, DataBuffer data) throws IOException {
        TupleOutput output = this.format.newOutput();
        this.objectToData(object, output);
        this.format.outputToData(output, data);
    }

    public DataFormat getDataFormat() {
        return this.format;
    }

    public abstract Object dataToObject(TupleInput var1) throws IOException;

    public abstract void objectToData(Object var1, TupleOutput var2) throws IOException;

    public static TupleBinding getPrimitiveBinding(Class cls, TupleFormat format) {
        if (cls == String.class) {
            return new StringBinding(format);
        }
        if (cls == Character.class) {
            return new CharacterBinding(format);
        }
        if (cls == Boolean.class) {
            return new BooleanBinding(format);
        }
        if (cls == Byte.class) {
            return new ByteBinding(format);
        }
        if (cls == Short.class) {
            return new ShortBinding(format);
        }
        if (cls == Integer.class) {
            return new IntegerBinding(format);
        }
        if (cls == Long.class) {
            return new LongBinding(format);
        }
        if (cls == Float.class) {
            return new FloatBinding(format);
        }
        if (cls == Double.class) {
            return new DoubleBinding(format);
        }
        return null;
    }

    private static class DoubleBinding
    extends TupleBinding {
        public DoubleBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Double(input.readDouble());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeDouble(((Number)object).doubleValue());
        }
    }

    private static class FloatBinding
    extends TupleBinding {
        public FloatBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Float(input.readFloat());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeFloat(((Number)object).floatValue());
        }
    }

    private static class LongBinding
    extends TupleBinding {
        public LongBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Long(input.readLong());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeLong(((Number)object).longValue());
        }
    }

    private static class IntegerBinding
    extends TupleBinding {
        public IntegerBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Integer(input.readInt());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeInt(((Number)object).intValue());
        }
    }

    private static class ShortBinding
    extends TupleBinding {
        public ShortBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Short(input.readShort());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeShort(((Number)object).shortValue());
        }
    }

    private static class ByteBinding
    extends TupleBinding {
        public ByteBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Byte(input.readByte());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeByte(((Number)object).byteValue());
        }
    }

    private static class BooleanBinding
    extends TupleBinding {
        public BooleanBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Boolean(input.readBoolean());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeBoolean((Boolean)object);
        }
    }

    private static class CharacterBinding
    extends TupleBinding {
        public CharacterBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Character(input.readChar());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeChar(((Character)object).charValue());
        }
    }

    private static class StringBinding
    extends TupleBinding {
        public StringBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return input.readString();
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeString((String)object);
        }
    }
}

