/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.collection.StoredCollection;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class StoredIterator
implements ListIterator,
Cloneable {
    private boolean lockForWrite;
    private StoredCollection coll;
    private DataCursor cursor;
    private int toNext;
    private int toPrevious;
    private int toCurrent;
    private boolean writeAllowed;
    private boolean setAndRemoveAllowed;
    private Object currentData;
    private final int NEXT_FLAG;
    private final int PREV_FLAG;
    private final boolean recNumAccess;

    public static void close(Iterator i) {
        if (i instanceof StoredIterator) {
            ((StoredIterator)i).close();
        }
    }

    StoredIterator(StoredCollection coll, boolean writeAllowed, DataCursor joinCursor) {
        try {
            this.coll = coll;
            this.writeAllowed = writeAllowed;
            this.cursor = joinCursor == null ? new DataCursor(coll.view, writeAllowed) : joinCursor;
            this.recNumAccess = this.cursor.hasRecNumAccess();
            if (coll.iterateDuplicates()) {
                this.NEXT_FLAG = Db.DB_NEXT;
                this.PREV_FLAG = Db.DB_PREV;
            } else {
                this.NEXT_FLAG = Db.DB_NEXT_NODUP;
                this.PREV_FLAG = Db.DB_PREV_NODUP;
            }
            this.reset();
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    protected Object clone() {
        try {
            StoredIterator o = (StoredIterator)super.clone();
            o.cursor = new DataCursor(this.cursor);
            return o;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public final boolean getLockForWrite() {
        return this.lockForWrite;
    }

    public void setLockForWrite(boolean lockForWrite) {
        this.lockForWrite = lockForWrite;
    }

    public boolean hasNext() {
        if (this.cursor == null) {
            return false;
        }
        try {
            int err;
            if (this.toNext != 0 && (err = this.cursor.get(null, null, this.toNext, this.lockForWrite)) == 0) {
                this.toNext = 0;
                this.toPrevious = this.PREV_FLAG;
                this.toCurrent = this.PREV_FLAG;
            }
            return this.toNext == 0;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public boolean hasPrevious() {
        if (this.cursor == null) {
            return false;
        }
        try {
            int err;
            if (this.toPrevious != 0 && (err = this.cursor.get(null, null, this.toPrevious, this.lockForWrite)) == 0) {
                this.toPrevious = 0;
                this.toNext = this.NEXT_FLAG;
                this.toCurrent = this.NEXT_FLAG;
            }
            return this.toPrevious == 0;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public Object next() {
        try {
            int err;
            if (this.toNext != 0 && (err = this.cursor.get(null, null, this.toNext, this.lockForWrite)) == 0) {
                this.toNext = 0;
            }
            if (this.toNext == 0) {
                this.currentData = this.coll.makeIteratorData(this, this.cursor);
                this.toNext = this.NEXT_FLAG;
                this.toPrevious = 0;
                this.toCurrent = 0;
                this.setAndRemoveAllowed = true;
                return this.currentData;
            }
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
        throw new NoSuchElementException();
    }

    public Object previous() {
        try {
            int err;
            if (this.toPrevious != 0 && (err = this.cursor.get(null, null, this.toPrevious, this.lockForWrite)) == 0) {
                this.toPrevious = 0;
            }
            if (this.toPrevious == 0) {
                this.currentData = this.coll.makeIteratorData(this, this.cursor);
                this.toPrevious = this.PREV_FLAG;
                this.toNext = 0;
                this.toCurrent = 0;
                this.setAndRemoveAllowed = true;
                return this.currentData;
            }
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
        throw new NoSuchElementException();
    }

    public int nextIndex() {
        if (!this.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        try {
            return this.hasNext() ? this.cursor.getCurrentRecordNumber() - this.coll.getIndexOffset() : Integer.MAX_VALUE;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public int previousIndex() {
        if (!this.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        try {
            return this.hasPrevious() ? this.cursor.getCurrentRecordNumber() - this.coll.getIndexOffset() : -1;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public void set(Object value) {
        if (!this.coll.hasValues()) {
            throw new UnsupportedOperationException();
        }
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            this.cursor.put(null, value, Db.DB_CURRENT, null);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public void remove() {
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            this.cursor.delete();
            this.setAndRemoveAllowed = false;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(Object value) {
        this.coll.checkIterAddAllowed();
        try {
            int err = 0;
            if (this.toNext != 0 && this.toPrevious != 0) {
                if (!this.coll.view.areKeysRenumbered()) throw new IllegalStateException("Collection is empty, cannot add() duplicate");
                this.close();
                err = this.coll.view.append(value, null, null);
                this.cursor = new DataCursor(this.coll.view, this.writeAllowed);
                this.reset();
                this.next();
            } else {
                int flags;
                if (this.coll.view.areKeysRenumbered()) {
                    this.moveToCurrent();
                    flags = this.hasNext() ? Db.DB_BEFORE : Db.DB_AFTER;
                } else {
                    flags = this.coll.areDuplicatesOrdered() ? Db.DB_NODUPDATA : (this.toNext == 0 ? Db.DB_BEFORE : Db.DB_AFTER);
                }
                err = this.cursor.put(null, value, flags, null, true);
                if (flags == Db.DB_BEFORE) {
                    this.toPrevious = 0;
                    this.toNext = this.NEXT_FLAG;
                }
            }
            if (err == -30996) {
                throw new IllegalArgumentException("Duplicate value");
            }
            if (err != 0) {
                throw new IllegalArgumentException("Could not insert: " + err);
            }
            this.setAndRemoveAllowed = false;
            return;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    private void reset() {
        this.toNext = Db.DB_FIRST;
        this.toPrevious = this.PREV_FLAG;
        this.toCurrent = 0;
        this.currentData = null;
        this.hasNext();
    }

    public int count() {
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            return this.cursor.count();
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public void close() {
        if (this.cursor != null) {
            this.coll.closeCursor(this.cursor);
            this.cursor = null;
        }
    }

    public final StoredCollection getCollection() {
        return this.coll;
    }

    final boolean isCurrentData(Object currentData) {
        return this.currentData == currentData;
    }

    final boolean moveToIndex(int index) {
        try {
            int err = this.cursor.get(new Integer(index), null, Db.DB_SET, this.lockForWrite);
            this.setAndRemoveAllowed = err == 0;
            return this.setAndRemoveAllowed;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    private void moveToCurrent() throws DbException, IOException {
        if (this.toCurrent != 0) {
            this.cursor.get(null, null, this.toCurrent, this.lockForWrite);
            this.toCurrent = 0;
        }
    }
}

