/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.util.ObjectUtilities;

public class AttributeList {
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private List entryList = new ArrayList();

    public Iterator iterator() {
        return this.entryList.iterator();
    }

    public void setAttribute(String namespace, String name, String value) {
        AttributeEntry entry = new AttributeEntry(namespace, name, value);
        int pos = this.entryList.indexOf(entry);
        if (pos != -1) {
            this.entryList.remove(pos);
        }
        this.entryList.add(entry);
    }

    public String getAttribute(String namespace, String name) {
        return this.getAttribute(namespace, name, null);
    }

    public String getAttribute(String namespace, String name, String defaultValue) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            AttributeEntry ae = (AttributeEntry)this.entryList.get(i);
            if (!ae.getName().equals(name) || !namespace.equals(name)) continue;
            return ae.getValue();
        }
        return defaultValue;
    }

    public void removeAttribute(String namespace, String name) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            AttributeEntry ae = (AttributeEntry)this.entryList.get(i);
            if (!ae.getName().equals(name) || !ae.getNamespace().equals(namespace)) continue;
            this.entryList.remove(ae);
            return;
        }
    }

    public boolean isEmpty() {
        return this.entryList.isEmpty();
    }

    public void addNamespaceDeclaration(String prefix, String namespaceUri) {
        if (namespaceUri == null) {
            throw new NullPointerException();
        }
        if (prefix == null || "".equals(prefix)) {
            this.setAttribute(XMLNS_NAMESPACE, "", namespaceUri);
        } else {
            this.setAttribute(XMLNS_NAMESPACE, prefix, namespaceUri);
        }
    }

    public void removeNamespaceDeclaration(String prefix) {
        if (prefix == null || "".equals(prefix)) {
            this.removeAttribute(XMLNS_NAMESPACE, "");
        } else {
            this.removeAttribute(XMLNS_NAMESPACE, prefix);
        }
    }

    public boolean isNamespacePrefixDefined(String prefix) {
        return this.getAttribute(XMLNS_NAMESPACE, prefix) != null;
    }

    public boolean isNamespaceUriDefined(String uri) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            AttributeEntry ae = (AttributeEntry)this.entryList.get(i);
            if (!ObjectUtilities.equal((Object)ae.getValue(), (Object)uri) || !XMLNS_NAMESPACE.equals(ae.getNamespace())) continue;
            return true;
        }
        return false;
    }

    public static class AttributeEntry {
        private String namespace;
        private String name;
        private String value;

        public AttributeEntry(String namespace, String name, String value) {
            if (name == null) {
                throw new NullPointerException("Name must not be null. [" + name + ", " + value + "]");
            }
            if (value == null) {
                throw new NullPointerException("Value must not be null. [" + name + ", " + value + "]");
            }
            this.namespace = namespace;
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeEntry that = (AttributeEntry)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return !(this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null);
        }

        public int hashCode() {
            int result = this.namespace != null ? this.namespace.hashCode() : 0;
            result = 29 * result + this.name.hashCode();
            return result;
        }
    }
}

