/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.common;

import org.jfree.xmlns.parser.ParseException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ParserUtil {
    private ParserUtil() {
    }

    public static int parseInt(String text, String message, Locator locator) throws SAXException {
        if (text == null) {
            throw new SAXException(message);
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("NumberFormatError: " + message, locator);
        }
    }

    public static int parseInt(String text, String message) throws SAXException {
        if (text == null) {
            throw new SAXException(message);
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            throw new SAXException("NumberFormatError: " + message);
        }
    }

    public static int parseInt(String text, int defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public static float parseFloat(String text, String message, Locator locator) throws ParseException {
        if (text == null) {
            throw new ParseException(message, locator);
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("NumberFormatError: " + message, locator);
        }
    }

    public static float parseFloat(String text, String message) throws SAXException {
        if (text == null) {
            throw new SAXException(message);
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            throw new SAXException("NumberFormatError: " + message);
        }
    }

    public static float parseFloat(String text, float defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public static boolean parseBoolean(String text, boolean defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        return text.equalsIgnoreCase("true");
    }

    public static Boolean parseBoolean(String value, Locator locator) throws ParseException {
        if (value == null) {
            return null;
        }
        if (value.equals("true")) {
            return Boolean.TRUE;
        }
        if (value.equals("false")) {
            return Boolean.FALSE;
        }
        throw new ParseException("Failed to parse value: Expected 'true' or 'false'", locator);
    }

    public static String parseString(String text, String defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        return text;
    }
}

