/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.parser;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ParseException
extends SAXException {
    private int line;
    private int column;
    private boolean noOwnMessage;

    public ParseException(String message) {
        super(message);
        this.fillLocation(null);
        this.noOwnMessage = message == null;
    }

    public ParseException(Exception e) {
        super(e);
        this.fillLocation(null);
        this.noOwnMessage = true;
    }

    public ParseException(String message, Exception e) {
        super(message, e);
        this.fillLocation(null);
        this.noOwnMessage = message == null;
    }

    public ParseException(String message, Locator locator) {
        super(message);
        this.fillLocation(locator);
        this.noOwnMessage = message == null;
    }

    public ParseException(Exception e, Locator locator) {
        super(e);
        this.fillLocation(locator);
        this.noOwnMessage = true;
    }

    public ParseException(String message, Exception e, Locator locator) {
        super(message, e);
        this.fillLocation(locator);
        this.noOwnMessage = message == null;
    }

    public String getMessage() {
        if (this.noOwnMessage) {
            Exception parentEx = this.getException();
            if (parentEx instanceof ParseException) {
                return parentEx.getMessage();
            }
            StringBuffer message = new StringBuffer(String.valueOf(parentEx.getMessage()));
            message.append(" [Location: Line=");
            message.append(this.line);
            message.append(" Column=");
            message.append(this.column);
            message.append("] ");
            return message.toString();
        }
        StringBuffer message = new StringBuffer(String.valueOf(super.getMessage()));
        message.append(" [Location: Line=");
        message.append(this.line);
        message.append(" Column=");
        message.append(this.column);
        message.append("] ");
        return message.toString();
    }

    protected void fillLocation(Locator locator) {
        if (locator == null) {
            this.line = -1;
            this.column = -1;
        } else {
            this.line = locator.getLineNumber();
            this.column = locator.getColumnNumber();
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        if (this.getException() != null) {
            stream.println("ParentException: ");
            this.getException().printStackTrace(stream);
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        if (this.getException() != null) {
            writer.println("ParentException: ");
            this.getException().printStackTrace(writer);
        }
    }
}

