/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.parser;

import java.net.URL;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.xml.sax.InputSource;

public class ResourceDataInputSource
extends InputSource {
    private ResourceData data;
    private long version;

    public ResourceDataInputSource(ResourceData data, ResourceManager caller) throws ResourceLoadingException {
        if (data == null) {
            throw new NullPointerException("Data must not be null");
        }
        this.data = data;
        this.version = data.getVersion(caller);
        this.setByteStream(data.getResourceAsStream(caller));
        URL url = caller.toURL(data.getKey());
        if (url != null) {
            this.setSystemId(url.toExternalForm());
        }
    }

    public ResourceData getData() {
        return this.data;
    }

    public long getVersion() {
        return this.version;
    }
}

