/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.writer;

import java.util.Enumeration;
import java.util.Properties;

public class CharacterEntityParser {
    private final Properties entities;
    private final Properties reverse;

    public CharacterEntityParser(Properties characterEntities) {
        this.entities = characterEntities;
        this.reverse = new Properties();
        Enumeration<Object> keys = this.entities.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = this.entities.getProperty(key);
            this.reverse.setProperty(value, key);
        }
    }

    public static CharacterEntityParser createXMLEntityParser() {
        Properties entities = new Properties();
        entities.setProperty("amp", "&");
        entities.setProperty("quot", "\"");
        entities.setProperty("lt", "<");
        entities.setProperty("gt", ">");
        entities.setProperty("apos", "'");
        return new CharacterEntityParser(entities);
    }

    private Properties getEntities() {
        return this.entities;
    }

    private Properties getReverse() {
        return this.reverse;
    }

    private String lookupCharacter(String key) {
        return this.getEntities().getProperty(key);
    }

    private String lookupEntity(String character) {
        String val = this.getReverse().getProperty(character);
        if (val == null) {
            return null;
        }
        return "&" + val + ";";
    }

    public String encodeEntities(String value) {
        StringBuffer writer = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            String character = String.valueOf(value.charAt(i));
            String lookup = this.lookupEntity(character);
            if (lookup == null) {
                writer.append(character);
                continue;
            }
            writer.append(lookup);
        }
        return writer.toString();
    }

    public String decodeEntities(String value) {
        int parserIndex = 0;
        int subStart = value.indexOf("&", parserIndex);
        if (subStart == -1) {
            return value;
        }
        int subEnd = value.indexOf(";", subStart);
        if (subEnd == -1) {
            return value;
        }
        StringBuffer bufValue = new StringBuffer(value.substring(0, subStart));
        do {
            if (value.charAt(subStart + 1) == '#') {
                int subValue = this.parseInt(value.substring(subStart + 2, subEnd), 0);
                if (subValue >= 1 && subValue <= 65536) {
                    char[] chr = new char[]{(char)subValue};
                    bufValue.append(chr);
                } else {
                    bufValue.append(value.substring(subStart, subEnd));
                }
            } else {
                String entity = value.substring(subStart + 1, subEnd);
                String replaceString = this.lookupCharacter(entity);
                if (replaceString != null) {
                    bufValue.append(this.decodeEntities(replaceString));
                } else {
                    bufValue.append("&");
                    bufValue.append(entity);
                    bufValue.append(";");
                }
            }
            parserIndex = subEnd + 1;
            subStart = value.indexOf("&", parserIndex);
            if (subStart == -1) {
                bufValue.append(value.substring(parserIndex));
                subEnd = -1;
                continue;
            }
            subEnd = value.indexOf(";", subStart);
            if (subEnd == -1) {
                bufValue.append(value.substring(parserIndex));
                continue;
            }
            bufValue.append(value.substring(parserIndex, subStart));
        } while (subStart != -1 && subEnd != -1);
        return bufValue.toString();
    }

    private int parseInt(String s, int defaultVal) {
        if (s == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }
}

