/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xmlns.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jfree.util.FastStack;
import org.jfree.util.ObjectUtilities;
import org.jfree.xmlns.common.AttributeList;
import org.jfree.xmlns.writer.DefaultTagDescription;
import org.jfree.xmlns.writer.TagDescription;

public class XmlWriterSupport {
    public static final int OPEN_TAG_INCREASE = 1;
    public static final int CLOSE_TAG_DECREASE = 2;
    public static final int INDENT_ONLY = 3;
    public static final boolean CLOSE = true;
    public static final boolean OPEN = false;
    private static String lineSeparator;
    private TagDescription safeTags;
    private FastStack openTags;
    private String indentString;
    private boolean lineEmpty;
    private int additionalIndent;
    private boolean alwaysAddNamespace;
    private boolean assumeDefaultNamespace;
    private Properties impliedNamespaces;
    private boolean writeFinalLinebreak;
    private boolean htmlCompatiblityMode;

    public XmlWriterSupport() {
        this(new DefaultTagDescription(), "  ");
    }

    public XmlWriterSupport(TagDescription safeTags, String indentString) {
        if (indentString == null) {
            throw new NullPointerException("IndentString must not be null");
        }
        if (safeTags == null) {
            throw new NullPointerException("SafeTags must not be null");
        }
        this.safeTags = safeTags;
        this.openTags = new FastStack();
        this.indentString = indentString;
        this.lineEmpty = true;
        this.writeFinalLinebreak = true;
    }

    public boolean isHtmlCompatiblityMode() {
        return this.htmlCompatiblityMode;
    }

    public void setHtmlCompatiblityMode(boolean htmlCompatiblityMode) {
        this.htmlCompatiblityMode = htmlCompatiblityMode;
    }

    public boolean isAlwaysAddNamespace() {
        return this.alwaysAddNamespace;
    }

    public void setAlwaysAddNamespace(boolean alwaysAddNamespace) {
        this.alwaysAddNamespace = alwaysAddNamespace;
    }

    public int getAdditionalIndent() {
        return this.additionalIndent;
    }

    public void setAdditionalIndent(int additionalIndent) {
        this.additionalIndent = additionalIndent;
    }

    public static synchronized String getLineSeparator() {
        if (lineSeparator == null) {
            try {
                lineSeparator = System.getProperty("line.separator", "\n");
            }
            catch (SecurityException se) {
                lineSeparator = "\n";
            }
        }
        return lineSeparator;
    }

    public void writeTag(Writer w, String namespaceUri, String name) throws IOException {
        this.writeTag(w, namespaceUri, name, null, false);
    }

    public void writeCloseTag(Writer w) throws IOException {
        this.indentForClose(w);
        ElementLevel level = (ElementLevel)this.openTags.pop();
        this.setLineEmpty(false);
        w.write("</");
        String prefix = level.getPrefix();
        if (prefix != null) {
            w.write(prefix);
            w.write(":");
            w.write(level.getTagName());
        } else {
            w.write(level.getTagName());
        }
        w.write(">");
        this.doEndOfLine(w);
    }

    public void writeNewLine(Writer writer) throws IOException {
        if (!this.isLineEmpty()) {
            writer.write(XmlWriterSupport.getLineSeparator());
            this.setLineEmpty(true);
        }
    }

    public boolean isLineEmpty() {
        return this.lineEmpty;
    }

    public void setLineEmpty(boolean lineEmpty) {
        this.lineEmpty = lineEmpty;
    }

    public void writeTag(Writer w, String namespace, String name, String attributeName, String attributeValue, boolean close) throws IOException {
        if (attributeName != null) {
            AttributeList attr = new AttributeList();
            attr.setAttribute(namespace, attributeName, attributeValue);
            this.writeTag(w, namespace, name, attr, close);
        } else {
            this.writeTag(w, namespace, name, null, close);
        }
    }

    public void addImpliedNamespace(String uri, String prefix) {
        if (prefix == null) {
            if (this.impliedNamespaces == null) {
                return;
            }
            this.impliedNamespaces.remove(uri);
        } else {
            if (this.impliedNamespaces == null) {
                this.impliedNamespaces = new Properties();
            }
            this.impliedNamespaces.setProperty(uri, prefix);
        }
    }

    public void copyNamespaces(XmlWriterSupport writerSupport) {
        if (this.impliedNamespaces == null) {
            this.impliedNamespaces = new Properties();
        }
        if (!writerSupport.openTags.isEmpty()) {
            ElementLevel parent = (ElementLevel)writerSupport.openTags.peek();
            this.impliedNamespaces.putAll((Map<?, ?>)parent.getNamespaces());
        }
        if (writerSupport.impliedNamespaces != null) {
            this.impliedNamespaces.putAll((Map<?, ?>)writerSupport.impliedNamespaces);
        }
    }

    public boolean isNamespaceDefined(String uri) {
        if (this.impliedNamespaces != null && this.impliedNamespaces.containsKey(uri)) {
            return true;
        }
        if (this.openTags.isEmpty()) {
            return false;
        }
        ElementLevel parent = (ElementLevel)this.openTags.peek();
        return parent.getNamespaces().containsKey(uri);
    }

    public boolean isNamespacePrefixDefined(String prefix) {
        if (this.impliedNamespaces != null && this.impliedNamespaces.containsValue(prefix)) {
            return true;
        }
        if (this.openTags.isEmpty()) {
            return false;
        }
        ElementLevel parent = (ElementLevel)this.openTags.peek();
        return parent.getNamespaces().containsValue(prefix);
    }

    public Properties getNamespaces() {
        if (this.openTags.isEmpty()) {
            Properties namespaces = new Properties();
            if (this.impliedNamespaces != null) {
                namespaces.putAll((Map<?, ?>)this.impliedNamespaces);
            }
            return namespaces;
        }
        ElementLevel parent = (ElementLevel)this.openTags.peek();
        Properties namespaces = new Properties();
        namespaces.putAll((Map<?, ?>)parent.getNamespaces());
        return namespaces;
    }

    public void writeTag(Writer w, String namespaceUri, String name, AttributeList attributes, boolean close) throws IOException {
        AttributeList.AttributeEntry entry;
        if (name == null) {
            throw new NullPointerException();
        }
        this.indent(w);
        this.setLineEmpty(false);
        Properties namespaces = this.getNamespaces();
        if (attributes != null) {
            Iterator attrs = attributes.iterator();
            while (attrs.hasNext()) {
                entry = (AttributeList.AttributeEntry)attrs.next();
                String prefix = entry.getName();
                if ("xmlns".equals(prefix)) {
                    if (entry.getNamespace() != null && !"".equals(entry.getNamespace())) continue;
                    namespaces.setProperty(entry.getValue(), "");
                    continue;
                }
                if (!"http://www.w3.org/2000/xmlns/".equals(entry.getNamespace())) continue;
                namespaces.setProperty(entry.getValue(), prefix);
            }
        }
        w.write("<");
        if (namespaceUri == null) {
            w.write(name);
            this.openTags.push((Object)new ElementLevel(name, namespaces));
        } else {
            String nsPrefix = namespaces.getProperty(namespaceUri);
            if (nsPrefix == null) {
                throw new IllegalArgumentException("Namespace " + namespaceUri + " is not defined.");
            }
            if ("".equals(nsPrefix)) {
                w.write(name);
                this.openTags.push((Object)new ElementLevel(namespaceUri, null, name, namespaces));
            } else {
                w.write(nsPrefix);
                w.write(":");
                w.write(name);
                this.openTags.push((Object)new ElementLevel(namespaceUri, nsPrefix, name, namespaces));
            }
        }
        if (attributes != null) {
            Iterator keys = attributes.iterator();
            while (keys.hasNext()) {
                entry = (AttributeList.AttributeEntry)keys.next();
                w.write(" ");
                w.write(this.buildAttributeName(entry, namespaces));
                w.write("=\"");
                w.write(XmlWriterSupport.normalize(entry.getValue(), true));
                w.write("\"");
            }
        }
        if (close) {
            if (this.isHtmlCompatiblityMode()) {
                w.write(" />");
            } else {
                w.write("/>");
            }
            this.openTags.pop();
            this.doEndOfLine(w);
        } else {
            w.write(">");
            this.doEndOfLine(w);
        }
    }

    private void doEndOfLine(Writer w) throws IOException {
        if (this.openTags.isEmpty()) {
            if (this.isWriteFinalLinebreak()) {
                this.writeNewLine(w);
            }
        } else {
            ElementLevel level = (ElementLevel)this.openTags.peek();
            if (!this.getTagDescription().hasCData(level.getNamespace(), level.getTagName())) {
                this.writeNewLine(w);
            }
        }
    }

    private String buildAttributeName(AttributeList.AttributeEntry entry, Properties namespaces) {
        ElementLevel currentElement = (ElementLevel)this.openTags.peek();
        if (!this.isAlwaysAddNamespace() && ObjectUtilities.equal((Object)currentElement.getNamespace(), (Object)entry.getNamespace())) {
            return entry.getName();
        }
        String name = entry.getName();
        String namespaceUri = entry.getNamespace();
        if (namespaceUri == null) {
            return name;
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceUri)) {
            if ("".equals(name)) {
                return "xmlns";
            }
            return "xmlns:" + name;
        }
        String namespacePrefix = namespaces.getProperty(namespaceUri);
        if (namespacePrefix != null && !"".equals(namespacePrefix)) {
            return namespacePrefix + ":" + name;
        }
        return name;
    }

    public static String normalize(String s, boolean transformNewLine) {
        if (s == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int len = s.length();
        block8: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block8;
                }
                case '>': {
                    str.append("&gt;");
                    continue block8;
                }
                case '&': {
                    str.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    if (transformNewLine) {
                        str.append("&#x000a;");
                        continue block8;
                    }
                    str.append('\n');
                    continue block8;
                }
                case '\r': {
                    if (transformNewLine) {
                        str.append("&#x000d;");
                        continue block8;
                    }
                    str.append('\r');
                    continue block8;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public void indent(Writer writer) throws IOException {
        if (this.openTags.isEmpty()) {
            for (int i = 0; i < this.additionalIndent; ++i) {
                writer.write(this.indentString);
            }
            return;
        }
        ElementLevel level = (ElementLevel)this.openTags.peek();
        if (!this.getTagDescription().hasCData(level.getNamespace(), level.getTagName())) {
            int i;
            this.doEndOfLine(writer);
            for (i = 0; i < this.openTags.size(); ++i) {
                writer.write(this.indentString);
            }
            for (i = 0; i < this.additionalIndent; ++i) {
                writer.write(this.indentString);
            }
        }
    }

    public void indentForClose(Writer writer) throws IOException {
        if (this.openTags.isEmpty()) {
            for (int i = 0; i < this.additionalIndent; ++i) {
                writer.write(this.indentString);
            }
            return;
        }
        ElementLevel level = (ElementLevel)this.openTags.peek();
        if (!this.getTagDescription().hasCData(level.getNamespace(), level.getTagName())) {
            int i;
            this.doEndOfLine(writer);
            for (i = 1; i < this.openTags.size(); ++i) {
                writer.write(this.indentString);
            }
            for (i = 0; i < this.additionalIndent; ++i) {
                writer.write(this.indentString);
            }
        }
    }

    public TagDescription getTagDescription() {
        return this.safeTags;
    }

    public void writeComment(Writer writer, String comment) throws IOException {
        if (!this.openTags.isEmpty()) {
            ElementLevel level = (ElementLevel)this.openTags.peek();
            if (!this.getTagDescription().hasCData(level.getNamespace(), level.getTagName())) {
                this.indent(writer);
            }
        }
        this.setLineEmpty(false);
        writer.write("<!-- ");
        writer.write(XmlWriterSupport.normalize(comment, false));
        writer.write(" -->");
        this.doEndOfLine(writer);
    }

    public boolean isAssumeDefaultNamespace() {
        return this.assumeDefaultNamespace;
    }

    public void setAssumeDefaultNamespace(boolean assumeDefaultNamespace) {
        this.assumeDefaultNamespace = assumeDefaultNamespace;
    }

    public int getCurrentIndentLevel() {
        return this.additionalIndent + this.openTags.size();
    }

    public void setWriteFinalLinebreak(boolean writeFinalLinebreak) {
        this.writeFinalLinebreak = writeFinalLinebreak;
    }

    public boolean isWriteFinalLinebreak() {
        return this.writeFinalLinebreak;
    }

    private static class ElementLevel {
        private String namespace;
        private String prefix;
        private String tagName;
        private Properties namespaces;

        protected ElementLevel(String namespace, String prefix, String tagName, Properties namespaces) {
            this.prefix = prefix;
            this.namespace = namespace;
            this.tagName = tagName;
            this.namespaces = namespaces;
        }

        protected ElementLevel(String tagName, Properties namespaces) {
            this.namespaces = namespaces;
            this.tagName = tagName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getTagName() {
            return this.tagName;
        }

        public Properties getNamespaces() {
            return this.namespaces;
        }
    }
}

