/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula;

import java.util.HashMap;
import org.jfree.formula.DefaultLocalizationContext;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaBoot;
import org.jfree.formula.LocalizationContext;
import org.jfree.formula.function.DefaultFunctionRegistry;
import org.jfree.formula.function.FunctionRegistry;
import org.jfree.formula.operators.DefaultOperatorFactory;
import org.jfree.formula.operators.OperatorFactory;
import org.jfree.formula.typing.DefaultTypeRegistry;
import org.jfree.formula.typing.Type;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.AnyType;
import org.jfree.util.Configuration;

public class DefaultFormulaContext
implements FormulaContext {
    private DefaultTypeRegistry typeRegistry;
    private DefaultFunctionRegistry functionRegistry;
    private OperatorFactory operatorFactory;
    private DefaultLocalizationContext localizationContext;
    private Configuration config;
    private HashMap references;

    public DefaultFormulaContext() {
        this(LibFormulaBoot.getInstance().getGlobalConfig());
    }

    public DefaultFormulaContext(Configuration config) {
        this.config = config;
        this.localizationContext = new DefaultLocalizationContext();
        this.localizationContext.initialize(config);
        this.typeRegistry = new DefaultTypeRegistry();
        this.typeRegistry.initialize(config, this);
        this.functionRegistry = new DefaultFunctionRegistry();
        this.functionRegistry.initialize(config);
        this.operatorFactory = new DefaultOperatorFactory();
        this.operatorFactory.initalize(config);
    }

    public OperatorFactory getOperatorFactory() {
        return this.operatorFactory;
    }

    public void defineReference(Object name, Object value) {
        if (this.references == null) {
            this.references = new HashMap();
        }
        this.references.put(name, value);
    }

    public Object resolveReference(Object name) {
        if (this.references == null) {
            return null;
        }
        return this.references.get(name);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public Type resolveReferenceType(Object name) {
        return AnyType.TYPE;
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public LocalizationContext getLocalizationContext() {
        return this.localizationContext;
    }

    public boolean isReferenceDirty(Object name) {
        return true;
    }
}

