/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.jfree.formula.LocalizationContext;
import org.jfree.formula.typing.Type;
import org.jfree.util.Configuration;

public class DefaultLocalizationContext
implements LocalizationContext {
    private static final String CONFIG_TIMEZONE_KEY = "org.jfree.formula.timezone";
    private static final String CONFIG_LOCALE_KEY = "org.jfree.formula.locale";
    private static final String CONFIG_DATEFORMAT_KEY = "org.jfree.formula.dateformat.";
    private List dateFormats = new ArrayList();
    private List datetimeFormats = new ArrayList();
    private List timeFormats = new ArrayList();
    private Locale locale;
    private TimeZone timeZone;

    public Locale getLocale() {
        return this.locale;
    }

    public ResourceBundle getBundle(String id) {
        return ResourceBundle.getBundle(id, this.getLocale());
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public List getDateFormats(Type type) {
        if (type.isFlagSet("type.date")) {
            return this.dateFormats;
        }
        if (type.isFlagSet("type.datetime")) {
            return this.datetimeFormats;
        }
        if (type.isFlagSet("type.time")) {
            return this.timeFormats;
        }
        return null;
    }

    private String[] createLocale(String locale) {
        StringTokenizer strtok = new StringTokenizer(locale, "_");
        String[] retval = new String[3];
        if (strtok.hasMoreElements()) {
            retval[0] = strtok.nextToken();
        }
        retval[1] = strtok.hasMoreElements() ? strtok.nextToken() : "";
        retval[2] = strtok.hasMoreElements() ? strtok.nextToken() : "";
        return retval;
    }

    private String[] createFormatSpec(String text) {
        StringTokenizer strtok = new StringTokenizer(text, ".");
        if (strtok.countTokens() == 2) {
            String[] retval = new String[]{strtok.nextToken(), strtok.nextToken()};
            return retval;
        }
        return null;
    }

    public void initialize(Configuration config) {
        String declaredLocale = config.getConfigProperty(CONFIG_LOCALE_KEY, Locale.getDefault().toString());
        String[] declaredLocaleParts = this.createLocale(declaredLocale);
        this.locale = new Locale(declaredLocaleParts[0], declaredLocaleParts[1], declaredLocaleParts[2]);
        String timeZoneId = config.getConfigProperty(CONFIG_TIMEZONE_KEY, TimeZone.getDefault().getID());
        this.timeZone = TimeZone.getTimeZone(timeZoneId);
        Iterator formatKeys = config.findPropertyKeys(CONFIG_DATEFORMAT_KEY);
        while (formatKeys.hasNext()) {
            String formatKey = (String)formatKeys.next();
            String format = config.getConfigProperty(formatKey);
            String keySpec = formatKey.substring(CONFIG_DATEFORMAT_KEY.length(), formatKey.length());
            String[] formatSpec = this.createFormatSpec(keySpec);
            if (formatSpec == null) continue;
            String type = "type." + formatSpec[0];
            String[] locale = this.createLocale(formatSpec[1]);
            SimpleDateFormat df = new SimpleDateFormat(format, new Locale(locale[0], locale[1], locale[2]));
            if ("type.time".equals(type)) {
                this.timeFormats.add(df);
                continue;
            }
            if ("type.date".equals(type)) {
                this.dateFormats.add(df);
                continue;
            }
            if (!"type.datetime".equals(type)) continue;
            this.datetimeFormats.add(df);
        }
        this.datetimeFormats.add(SimpleDateFormat.getDateTimeInstance(3, 3, this.getLocale()));
        this.dateFormats.add(SimpleDateFormat.getDateInstance(3, this.getLocale()));
        this.timeFormats.add(SimpleDateFormat.getTimeInstance(3, this.getLocale()));
        this.datetimeFormats.add(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.US));
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd", Locale.US));
        this.timeFormats.add(new SimpleDateFormat("hh:mm:ss", Locale.US));
    }
}

