/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula;

import java.io.Serializable;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.lvalues.LValue;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.parser.FormulaParser;
import org.jfree.formula.parser.ParseException;
import org.jfree.formula.parser.TokenMgrError;
import org.jfree.formula.typing.coretypes.ErrorType;
import org.jfree.util.Log;

public class Formula
implements Serializable,
Cloneable {
    private LValue rootReference;

    public Formula(String formulaText) throws ParseException {
        try {
            FormulaParser parser = new FormulaParser();
            this.rootReference = parser.parse(formulaText);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ParseException(tokenMgrError.getMessage());
        }
    }

    public Formula(LValue rootReference) {
        this.rootReference = rootReference;
    }

    public void initialize(FormulaContext context) throws EvaluationException {
        this.rootReference.initialize(context);
    }

    public LValue getRootReference() {
        return this.rootReference;
    }

    public TypeValuePair evaluateTyped() {
        try {
            TypeValuePair typeValuePair = this.rootReference.evaluate();
            if (typeValuePair == null) {
                return new TypeValuePair(ErrorType.TYPE, LibFormulaErrorValue.ERROR_NA_VALUE);
            }
            if (typeValuePair.getType().isFlagSet("type.error")) {
                Log.debug((Object)("Error: " + typeValuePair.getValue()));
            }
            return typeValuePair;
        }
        catch (EvaluationException ee) {
            Log.warn((Object)"Evaluation failed: ", (Exception)((Object)ee));
            return new TypeValuePair(ErrorType.TYPE, ee.getErrorValue());
        }
        catch (Exception e) {
            Log.warn((Object)"Evaluation failed: ", (Exception)e);
            return new TypeValuePair(ErrorType.TYPE, LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
    }

    public Object evaluate() {
        return this.evaluateTyped().getValue();
    }

    public Object clone() throws CloneNotSupportedException {
        Formula o = (Formula)super.clone();
        o.rootReference = (LValue)this.rootReference.clone();
        return o;
    }
}

