/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jfree.formula.function.DefaultFunctionDescription;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.FunctionCategory;
import org.jfree.formula.function.FunctionDescription;
import org.jfree.formula.function.FunctionRegistry;
import org.jfree.util.Configuration;
import org.jfree.util.HashNMap;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class DefaultFunctionRegistry
implements FunctionRegistry {
    private static final String FUNCTIONS_PREFIX = "org.jfree.formula.functions.";
    private FunctionCategory[] categories;
    private HashNMap categoryFunctions = new HashNMap();
    private HashMap functions;
    private HashMap functionMetaData = new HashMap();
    static /* synthetic */ Class class$org$jfree$formula$function$DefaultFunctionRegistry;
    static /* synthetic */ Class class$org$jfree$formula$function$Function;
    static /* synthetic */ Class class$org$jfree$formula$function$FunctionDescription;

    public DefaultFunctionRegistry() {
        this.functions = new HashMap();
        this.categories = new FunctionCategory[0];
    }

    public FunctionCategory[] getCategories() {
        return (FunctionCategory[])this.categories.clone();
    }

    public Function[] getFunctions() {
        String[] fnClasses = this.functions.values().toArray(new String[this.functions.size()]);
        ArrayList<Function> functions = new ArrayList<Function>(fnClasses.length);
        for (int i = 0; i < fnClasses.length; ++i) {
            String aClass = fnClasses[i];
            Function function = (Function)ObjectUtilities.loadAndInstantiate((String)aClass, (Class)(class$org$jfree$formula$function$DefaultFunctionRegistry == null ? DefaultFunctionRegistry.class$("org.jfree.formula.function.DefaultFunctionRegistry") : class$org$jfree$formula$function$DefaultFunctionRegistry), (Class)(class$org$jfree$formula$function$Function == null ? DefaultFunctionRegistry.class$("org.jfree.formula.function.Function") : class$org$jfree$formula$function$Function));
            if (function == null) {
                Log.debug((Object)("There is no such function: " + aClass));
                continue;
            }
            functions.add(function);
        }
        return functions.toArray(new Function[functions.size()]);
    }

    public String[] getFunctionNames() {
        return this.functions.keySet().toArray(new String[this.functions.size()]);
    }

    public String[] getFunctionNamesByCategory(FunctionCategory category) {
        return (String[])this.categoryFunctions.toArray((Object)category, (Object[])new String[0]);
    }

    public Function[] getFunctionsByCategory(FunctionCategory category) {
        String[] fnNames = (String[])this.categoryFunctions.toArray((Object)category, (Object[])new String[0]);
        ArrayList<Function> functions = new ArrayList<Function>(fnNames.length);
        for (int i = 0; i < fnNames.length; ++i) {
            String aName = fnNames[i];
            Function function = this.createFunction(aName);
            if (function == null) continue;
            functions.add(function);
        }
        return functions.toArray(new Function[functions.size()]);
    }

    public Function createFunction(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        String functionClass = (String)this.functions.get(name.toUpperCase());
        Function function = (Function)ObjectUtilities.loadAndInstantiate((String)functionClass, (Class)(class$org$jfree$formula$function$DefaultFunctionRegistry == null ? (class$org$jfree$formula$function$DefaultFunctionRegistry = DefaultFunctionRegistry.class$("org.jfree.formula.function.DefaultFunctionRegistry")) : class$org$jfree$formula$function$DefaultFunctionRegistry), (Class)(class$org$jfree$formula$function$Function == null ? (class$org$jfree$formula$function$Function = DefaultFunctionRegistry.class$("org.jfree.formula.function.Function")) : class$org$jfree$formula$function$Function));
        if (function == null) {
            Log.debug((Object)("There is no such function: " + name));
        }
        return function;
    }

    public FunctionDescription getMetaData(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return (FunctionDescription)this.functionMetaData.get(name.toUpperCase());
    }

    public void initialize(Configuration configuration) {
        Iterator functionKeys = configuration.findPropertyKeys(FUNCTIONS_PREFIX);
        HashSet<FunctionCategory> categories = new HashSet<FunctionCategory>();
        while (functionKeys.hasNext()) {
            Object fn;
            String className;
            String classKey = (String)functionKeys.next();
            if (!classKey.endsWith(".class") || (className = configuration.getConfigProperty(classKey)).length() == 0 || !((fn = ObjectUtilities.loadAndInstantiate((String)className, (Class)(class$org$jfree$formula$function$DefaultFunctionRegistry == null ? DefaultFunctionRegistry.class$("org.jfree.formula.function.DefaultFunctionRegistry") : class$org$jfree$formula$function$DefaultFunctionRegistry), (Class)(class$org$jfree$formula$function$Function == null ? DefaultFunctionRegistry.class$("org.jfree.formula.function.Function") : class$org$jfree$formula$function$Function))) instanceof Function)) continue;
            Function function = (Function)fn;
            int endIndex = classKey.length() - ".class".length();
            String descrKey = classKey.substring(0, endIndex) + ".description";
            String descrClassName = configuration.getConfigProperty(descrKey);
            Object descr = ObjectUtilities.loadAndInstantiate((String)descrClassName, (Class)(class$org$jfree$formula$function$DefaultFunctionRegistry == null ? DefaultFunctionRegistry.class$("org.jfree.formula.function.DefaultFunctionRegistry") : class$org$jfree$formula$function$DefaultFunctionRegistry), (Class)(class$org$jfree$formula$function$FunctionDescription == null ? DefaultFunctionRegistry.class$("org.jfree.formula.function.FunctionDescription") : class$org$jfree$formula$function$FunctionDescription));
            FunctionDescription description = !(descr instanceof FunctionDescription) ? new DefaultFunctionDescription(function.getCanonicalName()) : (FunctionDescription)descr;
            FunctionCategory cat = description.getCategory();
            this.categoryFunctions.add((Object)cat, (Object)function.getCanonicalName());
            this.functionMetaData.put(function.getCanonicalName(), description);
            this.functions.put(function.getCanonicalName(), className);
            categories.add(cat);
        }
        this.categories = categories.toArray(new FunctionCategory[categories.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

