/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.datetime;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.LocalizationContext;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.NumberType;

public class DateDifFunction
implements Function {
    public static final String YEARS_CODE = "y";
    public static final String MONTHS_CODE = "m";
    public static final String DAYS_CODE = "d";
    public static final String DAYS_IGNORING_YEARS = "yd";
    public static final String MONTHS_IGNORING_YEARS = "ym";
    public static final String DAYS_IGNORING_MONTHS_YEARS = "md";

    public String getCanonicalName() {
        return "DATEDIF";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int res;
        if (parameters.getParameterCount() != 3) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Date date1 = typeRegistry.convertToDate(parameters.getType(0), parameters.getValue(0));
        Date date2 = typeRegistry.convertToDate(parameters.getType(1), parameters.getValue(1));
        String formatCode = typeRegistry.convertToText(parameters.getType(2), parameters.getValue(2));
        if (date1 == null || date2 == null || formatCode == null || "".equals(formatCode)) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        LocalizationContext localizationContext = context.getLocalizationContext();
        TimeZone timeZone = localizationContext.getTimeZone();
        Locale locale = localizationContext.getLocale();
        GregorianCalendar calandar1 = new GregorianCalendar(timeZone, locale);
        calandar1.setTime(date1);
        GregorianCalendar calandar2 = new GregorianCalendar(timeZone, locale);
        calandar2.setTime(date2);
        if (YEARS_CODE.equals(formatCode)) {
            res = calandar2.get(1) - calandar1.get(1);
        } else if (MONTHS_CODE.equals(formatCode)) {
            int month1 = calandar1.get(2);
            int month2 = calandar2.get(2);
            int year1 = calandar1.get(1);
            int year2 = calandar2.get(1);
            res = (year2 - year1) * 12 + month2 - month1;
        } else if (DAYS_IGNORING_MONTHS_YEARS.equals(formatCode)) {
            calandar1.set(1, calandar2.get(1));
            calandar1.set(2, calandar2.get(2));
            res = calandar2.get(5) - calandar1.get(5);
        } else if (DAYS_CODE.equals(formatCode)) {
            int dayOfYear1 = calandar1.get(6);
            int dayOfYear2 = calandar2.get(6);
            int year1 = calandar1.get(1);
            int year2 = calandar2.get(1);
            GregorianCalendar workingCalandar = new GregorianCalendar(timeZone, locale);
            res = dayOfYear2 - dayOfYear1;
            int targetYear = Math.max(year1, year2);
            for (int i = Math.min(year1, year2); i < targetYear; ++i) {
                workingCalandar.set(1, i);
                res += workingCalandar.getActualMaximum(6);
            }
        } else if (MONTHS_IGNORING_YEARS.equals(formatCode)) {
            int month1 = calandar1.get(2);
            int month2 = calandar2.get(2);
            res = month2 - month1;
        } else if (DAYS_IGNORING_YEARS.equals(formatCode)) {
            calandar1.set(1, calandar2.get(1));
            int dayOne = calandar1.get(6);
            int dayTwo = calandar2.get(6);
            res = Math.abs(dayOne - dayTwo);
        } else {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (res < 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new Integer(res));
    }
}

