/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.datetime;

import java.math.BigDecimal;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.NumberType;
import org.jfree.formula.util.NumberUtil;

public class HourFunction
implements Function {
    private static final BigDecimal HOUR_24 = new BigDecimal(24);

    public String getCanonicalName() {
        return "HOUR";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() != 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Number n = typeRegistry.convertToNumber(parameters.getType(0), parameters.getValue(0));
        if (n == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        BigDecimal bd = NumberUtil.getAsBigDecimal(n);
        BigDecimal round1 = new BigDecimal(NumberUtil.performIntRounding(bd));
        BigDecimal dayFraction = bd.subtract(round1);
        Integer hour = NumberUtil.performIntRounding(dayFraction.multiply(HOUR_24));
        return new TypeValuePair(NumberType.GENERIC_NUMBER, hour);
    }
}

