/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.datetime;

import java.sql.Time;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.LocalizationContext;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.DateTimeType;
import org.jfree.formula.util.DateUtil;

public class TimeFunction
implements Function {
    public String getCanonicalName() {
        return "TIME";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Number n3;
        Number n2;
        Number n1;
        if (parameters.getParameterCount() != 3) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        try {
            TypeRegistry typeRegistry = context.getTypeRegistry();
            n1 = typeRegistry.convertToNumber(parameters.getType(0), parameters.getValue(0));
            n2 = typeRegistry.convertToNumber(parameters.getType(1), parameters.getValue(1));
            n3 = typeRegistry.convertToNumber(parameters.getType(2), parameters.getValue(2));
        }
        catch (NumberFormatException e) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (n1 == null || n2 == null || n3 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        int hours = n1.intValue();
        int minutes = n2.intValue();
        int seconds = n3.intValue();
        LocalizationContext localizationContext = context.getLocalizationContext();
        Time time = DateUtil.createTime(hours, minutes, seconds, localizationContext);
        return new TypeValuePair(DateTimeType.TIME_TYPE, time);
    }
}

