/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.datetime;

import java.util.Calendar;
import java.util.Date;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.NumberType;
import org.jfree.formula.util.DateUtil;

public class WeekDayFunction
implements Function {
    public String getCanonicalName() {
        return "WEEKDAY";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() > 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Date d = typeRegistry.convertToDate(parameters.getType(0), parameters.getValue(0));
        int type = 1;
        if (parameters.getParameterCount() == 2) {
            Number n = typeRegistry.convertToNumber(parameters.getType(1), parameters.getValue(1));
            if (n == null) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            type = n.intValue();
            if (type < 1 || type > 3) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        }
        if (d == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        Calendar gc = DateUtil.createCalendar(d, context.getLocalizationContext());
        int dayOfWeek = gc.get(7);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new Integer(this.convertType(dayOfWeek, type)));
    }

    public int convertType(int currentDayOfWeek, int type) {
        if (type == 1) {
            return currentDayOfWeek;
        }
        if (type == 2) {
            int i = (currentDayOfWeek + 6) % 8;
            if (i == 7) {
                return i;
            }
            return i + 1;
        }
        return (currentDayOfWeek + 5) % 7;
    }
}

