/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.formula.function.datetime;

import java.util.Calendar;
import java.util.Date;
import org.jfree.formula.EvaluationException;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.LibFormulaErrorValue;
import org.jfree.formula.function.Function;
import org.jfree.formula.function.ParameterCallback;
import org.jfree.formula.lvalues.TypeValuePair;
import org.jfree.formula.typing.TypeRegistry;
import org.jfree.formula.typing.coretypes.NumberType;
import org.jfree.formula.util.DateUtil;

public class YearFunction
implements Function {
    public String getCanonicalName() {
        return "YEAR";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() != 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Date d = typeRegistry.convertToDate(parameters.getType(0), parameters.getValue(0));
        if (d == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        Calendar gc = DateUtil.createCalendar(d, context.getLocalizationContext());
        int year = gc.get(1);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new Integer(year));
    }
}

